<?php
/**
 * Saas Banner Widget
 */

namespace Elementor;
class Stike_Saas_Banner extends Widget_Base {

	public function get_name() {
        return 'Stike_Saas_Banner';
    }

	public function get_title() {
        return __( 'Saas Banner', 'stike-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return [ 'stike-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Stike_Saas_Banner_Area',
			[
				'label' => __( 'Stike Banner Controls', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'image',
			[
				'label' => __( 'Choose Banner Image', 'stike-toolkit' ),
				'type' => Controls_Manager::MEDIA,
			]
        );


        $this->add_control(
            'image_shape',
            [
                'label' => __( 'Remove Background Shape Images?', 'stike-toolkit' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'stike-toolkit' ),
                'label_off' => __( 'No', 'stike-toolkit' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'stike-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Manage your business strategy in one placeholder', 'stike-toolkit'),
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => __( 'Content', 'stike-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Our passion to work hard and deliver excellent results. It could solve the needs of your customers and develop innovation. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.', 'stike-toolkit'),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'stike-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Get Started', 'stike-toolkit'),
            ]
        );

        $this->add_control(
            'button_icon',
            [
                'label' => __( 'Button Icon', 'stike-toolkit' ),
                'type' => Controls_Manager::ICON,
            ]
        );

        $this->add_control(
            'button_link',
            [
                'label' => __( 'Button Link', 'stike-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $this->add_control(
            'video_button_text',
            [
                'label' => __( 'Video Button Text', 'stike-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Watch Video', 'stike-toolkit'),
            ]
        );

        $this->add_control(
            'video_button_icon',
            [
                'label' => __( 'Video Button Icon', 'stike-toolkit' ),
                'type' => Controls_Manager::ICON,
            ]
        );

        $this->add_control(
            'video_button_link',
            [
                'label' => __( 'Video Link', 'stike-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'title_color',
			[
				'label' => __( 'Title Color', 'stike-toolkit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .saas-banner .hero-content h1' => 'color: {{VALUE}}',
				],
			]
        );

        $this->add_responsive_control(
			'title_size',
			[
				'label' => __( 'Title Font Size', 'stike-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 70,
						'step' => 1,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'selectors' => [
					'{{WRAPPER}} .saas-banner .hero-content h1' => 'font-size: {{SIZE}}px;',
				],
			]
		);
        
        $this->add_control(
			'content_color',
			[
				'label' => __( 'Content Color', 'stike-toolkit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .saas-banner .hero-content p' => 'color: {{VALUE}}',
				],
			]
        );
        
        $this->add_responsive_control(
			'content_size',
			[
				'label' => __( 'Content Font Size', 'stike-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 50,
						'step' => 1,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'selectors' => [
					'{{WRAPPER}} .saas-banner .hero-content p' => 'font-size: {{SIZE}}px;',
				],
			]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');

        // Button icon
        $button_icon = '';
        if( $settings['button_icon'] != '' ):
            $button_icon = $settings['button_icon'];
        else:
            $button_icon   = 'bx bxs-hot';
        endif;
        
        // Video button icon
        $video_button_icon = '';
        if( $settings['video_button_icon'] != '' ):
            $video_button_icon = $settings['video_button_icon'];
        else:
            $video_button_icon   = 'bx bxs-right-arrow';
        endif;

        ?>
        <div class="saas-banner">
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container max-width-1290">
                        <div class="row align-items-center pt-5">
                            <div class="col-lg-6 col-md-12">
                                <div class="saas-image mt-70">
                                    <?php if( $settings['image']['url'] != '' ): ?> 
                                        <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" class="wow fadeInDown bannerrightimg" alt="<?php echo esc_attr($settings['title']); ?>">
                                    <?php else: ?>
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/arrow.png" class="wow fadeInDown" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/box1.png" class="wow fadeInUp" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/boy1.png" class="wow fadeInLeft" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/boy2.png" class="wow zoomIn" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/boy3.png" class="wow bounceIn" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/digital-screen.png" class="wow fadeInDown" data-wow-delay="0.6s" alt="digital-screen">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/filter1.png" class="wow zoomIn" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/filter2.png" class="wow fadeInUp" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/filter3.png" class="wow rotateIn" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/girl1.png" class="wow fadeInUp" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/girl2.png" class="wow zoomIn" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/monitor.png" class="wow zoomIn" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">

                                        <!-- Main image -->
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/main-image.png" class="wow zoomIn" data-wow-delay="0.6s" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-12">
                                <div class="hero-content pl-4">
                                    <h1 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h1>
                                    <p <?php echo $this-> get_render_attribute_string('content'); ?>><?php echo esc_html( $settings['content'] ); ?></p>

                                    <div class="banner-btn">
                                        <div class="d-flex">
                                            <?php if( $settings['button_text'] != '' ): ?>
                                                <a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>" class="default-btn">
                                                    <i class="<?php echo esc_attr( $button_icon ); ?>"></i>
                                                    <?php echo esc_html( $settings['button_text'] ); ?> 
                                                    <span></span>
                                                </a>
                                            <?php endif; ?>

                                            <?php if( $settings['video_button_text'] != '' ): ?>
                                                <a href="<?php echo esc_url( $settings['video_button_link']['url'] ); ?>" class="video-btn popup-youtube"> 
                                                    <i class='<?php echo esc_attr( $video_button_icon ); ?>'></i> <?php echo esc_html( $settings['video_button_text'] ); ?>  
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php if( $settings['image_shape'] != 'yes' ): ?>
                <div class="shape-rotate rotateme">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/saas-shape/shape-rotate.png" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                </div>
                <div id="particles-js"></div>
            <?php endif; ?>  
        </div>
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Stike_Saas_Banner );