<?php
/**
 * Funfacts Widget
 */

namespace Elementor;
class Stike_Funfacts extends Widget_Base {

	public function get_name() {
        return 'Stike_Funfacts';
    }

	public function get_title() {
        return __( 'Funfacts', 'stike-toolkit' );
    }

	public function get_icon() {
        return 'eicon-counter';
    }

	public function get_categories() {
        return [ 'stike-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'funfacts_section',
			[
				'label' => __( 'Funfacts Control', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );


            $this->add_control(
                'items',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'label'   => esc_html__( 'Add Counter Item', 'stike-toolkit' ),			                 
                    'fields'  => array(		
                        
                        array(
                            'name'  => 'card_style',
                            'label' => __( 'Style', 'stike-toolkit' ),
                            'type' => Controls_Manager::SELECT,
                            'options' => [
                                '1'   => __( 'Style One', 'stike-toolkit' ),
                                '2'   => __( 'Style Two', 'stike-toolkit' ),
                            ],
                            'default' => '1',
                        ),
                        array(
                            'type'    => Controls_Manager::NUMBER,
                            'name'    => 'number',
                            'label'   => esc_html__( 'Ending Number', 'stike-toolkit' ),
                        ),	
                        array(
                            'type'    => Controls_Manager::ICON,
                            'name'    => 'icon',
                            'label'   => esc_html__( 'Icon', 'stike-toolkit' ),
                            'condition' => [
                                'card_style' => '2',
                            ],
                        ),		
                        array(
                            'type'    => Controls_Manager::TEXT,
                            'name'    => 'suffix',
                            'label'   => esc_html__( 'Number Suffix', 'stike-toolkit' ),
                        ),
                        array(
                            'type'    => Controls_Manager::TEXT,
                            'name'    => 'title',
                            'label'   => esc_html__( 'Title', 'stike-toolkit' ),
                        ),
                    ),	
                ]			
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'counter_style',
			[
				'label' => __( 'Style', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_responsive_control(
                'margin_top',
                [
                    'label' => __( 'Margin Top', 'stike-toolkit' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                    ],
                    'devices' => [ 'desktop', 'tablet', 'mobile' ],
                    'selectors' => [
                        '{{WRAPPER}} .funfacts-inner' => 'margin-top: {{SIZE}}px;',
                    ],
                ]
            );

            $this->add_control(
                'counter_color',
                [
                    'label' => __( 'Number Color', 'stike-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-funfacts h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_responsive_control(
				'number_size',
				[
					'label' => __( 'Number Font Size', 'stike-toolkit' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 70,
							'step' => 1,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .single-funfacts h3 .sign-icon, .single-funfacts h3' => 'font-size: {{SIZE}}px;',
					],
				]
			);

            $this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'stike-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-funfacts p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'title_size',
				[
					'label' => __( 'Title Font Size', 'stike-toolkit' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 70,
							'step' => 1,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .single-funfacts p' => 'font-size: {{SIZE}}px;',
					],
				]
			);

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        
        ?>
        <div class="funfacts-inner">
            <div class="row">
                <?php foreach( $settings['items'] as $item ): ?>
                    <?php if( $item['card_style'] == '2' ): ?>
                        <div class="col-lg-3 col-6 col-sm-6">
                            <div class="single-funfacts funfact-style-two wow fadeInLeft" data-wow-delay=".2s">
                                <i class='<?php echo esc_html( $item['icon'] ); ?>'></i>
                                <h3><span class="odometer" data-count="<?php echo esc_attr( $item['number'] ); ?>">00</span><span class="sign-icon"><?php echo esc_html( $item['suffix'] ); ?></span></h3>
                                <p><?php echo esc_html( $item['title'] ); ?></p>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="col-lg-3 col-6 col-sm-3 col-md-3">
                            <div class="single-funfacts">
                                <h3><span class="odometer" data-count="<?php echo esc_attr( $item['number'] ); ?>">00</span><span class="sign-icon"><?php echo esc_html( $item['suffix'] ); ?></span></h3>
                                <p><?php echo esc_html( $item['title'] ); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
	}
	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Stike_Funfacts );