<?php
/**
 * CTA Widget
 */

namespace Elementor;
class Stike_CTA extends Widget_Base {

	public function get_name() {
        return 'Stike_CTA';
    }

	public function get_title() {
        return __( 'CTA', 'stike-toolkit' );
    }

	public function get_icon() {
        return 'eicon-call-to-action';
    }

	public function get_categories() {
        return [ 'stike-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Stike_CTA_Area',
			[
				'label' => __( 'CTA Controls', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'stike-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('Practice active listening and follow through', 'stike-toolkit'),
				]
			);

			$this->add_control(
				'description',
				[
					'label' => __( 'Description', 'stike-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => __('Qualify your leads & recognize the value of word your customer will love you', 'stike-toolkit'),
				]
			);

			$this->add_control(
				'button_text',
				[
					'label' => __( 'Button Text', 'stike-toolkit' ),
					
					'type' => Controls_Manager::TEXT,
					'default' => __('Try It Free Now', 'stike-toolkit'),
				]
			);

			$this->add_control(
				'button_link',
				[
					'label' => __( 'Button Link', 'stike-toolkit' ),
					'type' => Controls_Manager::URL,
				]
			);
        
        $this->end_controls_section();

        $this->start_controls_section(
			'cta_style',
			[
				'label' => __( 'Style', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

			$this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'stike-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .free-trial-content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'title_size',
				[
					'label' => __( 'Title Font Size', 'stike-toolkit' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 70,
							'step' => 1,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .free-trial-content h2' => 'font-size: {{SIZE}}px;',
					],
				]
			);
			
			$this->add_control(
				'description_color',
				[
					'label' => __( 'Description Title Color', 'stike-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .free-trial-content p' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_responsive_control(
				'description_size',
				[
					'label' => __( 'Description Title Font Size', 'stike-toolkit' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 40,
							'step' => 1,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .free-trial-content p' => 'font-size: {{SIZE}}px;',
					],
				]
			);

			$this->add_responsive_control(
				'button_size',
				[
					'label' => __( 'Button Text Font Size', 'stike-toolkit' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 35,
							'step' => 1,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .free-trial-content .default-btn' => 'font-size: {{SIZE}}px;',
					],
				]
            );
            
			$this->add_control(
				'show_button_icon',
				[
					'label' => __( 'Button Icon', 'stike-toolkit' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => __( 'Show', 'stike-toolkit' ),
					'label_off' => __( 'Hide', 'stike-toolkit' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
            );
            
            $this->add_control(
				'shape',
				[
					'label' => __( 'Shape Image', 'stike-toolkit' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => __( 'Show', 'stike-toolkit' ),
					'label_off' => __( 'Hide', 'stike-toolkit' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'padding',
				[
					'label' => __( 'Padding', 'stike-toolkit' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => __( 'Bottom', 'stike-toolkit' ),
					'label_off' => __( 'Top Bottom', 'stike-toolkit' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();
		
        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
		$this-> add_inline_editing_attributes('description','none');

		if( $settings['padding'] == 'yes' ):
			$padding_class = 'pb-100';
		else:
			$padding_class = 'ptb-100';
		endif;
	
        ?>
        <div class="free-trial-area <?php echo esc_attr( $padding_class ); ?> bg-f4f5fe">
            <div class="container">
                <div class="free-trial-content">
                    <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>
                    <p <?php echo $this-> get_render_attribute_string('description'); ?>><?php echo esc_html( $settings['description'] ); ?></p>

                    <?php if( $settings['button_text'] != '' &&  $settings['button_link']['url'] != '' ): ?>
                        <a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>" class="default-btn">
                            <?php if( $settings['show_button_icon'] == 'yes' ): ?>
                                <i class="bx bxs-hot"></i>
                            <?php endif; ?>
                            <?php echo esc_html( $settings['button_text'] ); ?>
                            <span></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>

            <?php if( $settings['shape'] == 'yes' ): ?>
                <div class="shape10"><img src="<?php echo esc_url( STIKE_IMG .'/shape/10.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                <div class="shape11"><img src="<?php echo esc_url( STIKE_IMG .'/shape/7.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                <div class="shape12"><img src="<?php echo esc_url( STIKE_IMG .'/shape/11.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                <div class="shape13"><img src="<?php echo esc_url( STIKE_IMG .'/shape/12.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
            <?php endif; ?>
        </div>
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Stike_CTA );