<?php
/**
 * Contact CTA Widget
 */

namespace Elementor;
class Stike_Contact_CTA extends Widget_Base {

	public function get_name() {
        return 'Stike_Contact_CTA';
    }

	public function get_title() {
        return __( 'Contact CTA', 'stike-toolkit' );
    }

	public function get_icon() {
        return 'eicon-call-to-action';
    }

	public function get_categories() {
        return [ 'stike-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Stike_Contact_CTA_Area',
			[
				'label' => __( 'Contact CTA Controls', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'stike-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('Have any question about us?', 'stike-toolkit'),
				]
			);

			$this->add_control(
				'short_title',
				[
					'label' => __( 'Short Title', 'stike-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => __('Dont hesitate to contact us.', 'stike-toolkit'),
				]
			);

			$this->add_control(
				'button_text',
				[
					'label' => __( 'Button Text', 'stike-toolkit' ),
					
					'type' => Controls_Manager::TEXT,
					'default' => __('Contact Us', 'stike-toolkit'),
				]
			);

			$this->add_control(
				'button_link',
				[
					'label' => __( 'Button Link', 'stike-toolkit' ),
					'type' => Controls_Manager::URL,
				]
			);
        
        $this->end_controls_section();

        $this->start_controls_section(
			'contact_cta__style',
			[
				'label' => __( 'Style', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

			$this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'stike-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .contact-cta-box h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'title_size',
				[
					'label' => __( 'Title Font Size', 'stike-toolkit' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 70,
							'step' => 1,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .contact-cta-box h3' => 'font-size: {{SIZE}}px;',
					],
				]
			);
			
			$this->add_control(
				'short_title_color',
				[
					'label' => __( 'Short Title Color', 'stike-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .contact-cta-box p' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_responsive_control(
				'short_title_size',
				[
					'label' => __( 'Short Title Font Size', 'stike-toolkit' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 40,
							'step' => 1,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .contact-cta-box p' => 'font-size: {{SIZE}}px;',
					],
				]
			);

			$this->add_responsive_control(
				'button_size',
				[
					'label' => __( 'Button Text Font Size', 'stike-toolkit' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 35,
							'step' => 1,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .contact-cta-box .default-btn' => 'font-size: {{SIZE}}px;',
					],
				]
            );
            
            $this->add_responsive_control(
                'margin_top',
                [
                    'label' => __( 'Margin Top', 'stike-toolkit' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                    ],
                    'devices' => [ 'desktop', 'tablet', 'mobile' ],
                    'selectors' => [
                        '{{WRAPPER}} .contact-cta-box' => 'margin-top: {{SIZE}}px;',
                    ],
                ]
            );

			$this->add_control(
				'show_button_icon',
				[
					'label' => __( 'Button Icon', 'stike-toolkit' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => __( 'Show', 'stike-toolkit' ),
					'label_off' => __( 'Hide', 'stike-toolkit' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();
		
        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
		$this-> add_inline_editing_attributes('short_title','none');
	
        ?>
        <div class="contact-cta-box mwidth-1000">
            <h3 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h3>
            <p <?php echo $this-> get_render_attribute_string('short_title'); ?>><?php echo esc_html( $settings['short_title'] ); ?></p>

            <?php if( $settings['button_text'] != '' &&  $settings['button_link']['url'] != '' ): ?>
                <a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>" class="default-btn">
                    <?php if( $settings['show_button_icon'] == 'yes' ): ?>
                        <i class="bx bxs-edit-alt"></i>
                    <?php endif; ?>
                    <?php echo esc_html( $settings['button_text'] ); ?>
                    <span></span>
                </a>
            <?php endif; ?>
        </div>
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Stike_Contact_CTA );