<?php
/**
 * One Click Demo Import
 * @package WordPress
 * @subpackage stike
 * 
 */
if ( ! function_exists( 'stike_import_files' ) ) {
    function stike_import_files() {
        return array(
            array(
                'import_file_name'             => esc_html__('Stike Demo Data', 'stike'),
                'local_import_file'            => trailingslashit( get_template_directory() ) . '/lib/demo-data/stike-demo.xml',
                'local_import_widget_file'     => trailingslashit( get_template_directory() ) . '/lib/demo-data/stike-widgets.json',
                'local_import_customizer_file' => trailingslashit( get_template_directory() ) . '/lib/demo-data/stike-export.dat',
                'local_import_redux'           => array(
                    array(
                        'file_path'   => trailingslashit( get_template_directory() ) . '/lib/demo-data/redux-options.json',
                        'option_name' => 'stike_opt',
                    ),
                ),
                'import_notice'                => esc_html__( 'After import demo, just set static homepage from settings>reading and check widgets & menus.', 'stike' ),
            ),
        );
    }
}

$pcs = trim( get_option( 'stike_purchase_code_status' ) );
if ( $pcs == 'valid' ) :
    add_filter( 'pt-ocdi/import_files', 'stike_import_files' );
endif;