<?php
/**
 * Newsletter Widget
 */

namespace Elementor;
class Stike_Newsletter extends Widget_Base {

	public function get_name() {
        return 'Stike_Newsletter';
    }

	public function get_title() {
        return __( 'Newsletter', 'stike-toolkit' );
    }

	public function get_icon() {
        return 'eicon-email-field';
    }

	public function get_categories() {
        return [ 'stike-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Stike_Newsletter',
			[
				'label' => __( 'Stike Newsletter', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'content_style',
            [
                'label' => __( 'Style', 'tryo-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'         => __( 'Style One', 'tryo-toolkit' ),
                    '2'         => __( 'Style Two', 'tryo-toolkit' ),
                ],
                'default' => '1',
            ]
        );

        $this->add_control(
			'title', [
				'label' => __( 'Title', 'stike-toolkit' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'We always try to be as close to you as possible' , 'stike-toolkit' ),
				'label_block' => true,
			]
        );

        $this->add_control(
			'placeholder_text', [
				'label' => __( 'Placeholder Text', 'stike-toolkit' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'hello@stike.com' , 'stike-toolkit' ),
				'label_block' => true,
			]
        );

        $this->add_control(
			'button_text', [
				'label' => __( 'Button text', 'stike-toolkit' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Subscribe Now' , 'stike-toolkit' ),
				'label_block' => true,
			]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'newsletter_style',
			[
				'label' => __( 'Style', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'background_color',
                [
                    'label' => __( 'Background Color', 'stike-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .subscribe-content' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'stike-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .subscribe-content h2' => 'color: {{VALUE}}',
                    ],
                ]
                
            );

            $this->add_responsive_control(
                'title_size',
                [
                    'label' => __( 'Title Font Size', 'stike-toolkit' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 80,
                            'step' => 1,
                        ],
                    ],
                    'devices' => [ 'desktop', 'tablet', 'mobile' ],
                    'selectors' => [
                        '{{WRAPPER}} .subscribe-content h2' => 'font-size: {{SIZE}}px;',
                    ],
                ]
            );

            $this->add_control(
				'show_shape',
				[
					'label' => __( 'Shape Images', 'stike-toolkit' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => __( 'Show', 'stike-toolkit' ),
					'label_off' => __( 'Hide', 'stike-toolkit' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        ?>
        <?php if( $settings['content_style'] == '2' ): ?>
            <div class="subscribe-content border-radius-0">
                <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>
                
                <form class="newsletter-form" method="post" action="<?php echo home_url(); ?>/?na=s" onsubmit="return newsletter_check(this)">
                    <div class="row align-items-center">
                        <div class="col-lg-8 col-md-8">
                            <input type="email" name="ne" class="input-newsletter" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" required autocomplete="off">
                        </div>

                        <div class="col-lg-4 col-md-4">
                            <?php if( $settings['button_text'] != '' ): ?>
                                <button type="submit"><i class="bx bxs-hot"></i> <?php echo esc_html( $settings['button_text'] ); ?></button>
                            <?php endif; ?>
                        </div>
                    </div>
                </form>
                
                <?php if( $settings['show_shape'] == 'yes' ): ?>
                    <div class="shape14"><img src="<?php echo esc_url( STIKE_IMG .'/shape/13.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                    <div class="shape15"><img src="<?php echo esc_url( STIKE_IMG .'/shape/14.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                    <div class="shape16"><img src="<?php echo esc_url( STIKE_IMG .'/shape/15.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                    <div class="shape17"><img src="<?php echo esc_url( STIKE_IMG .'/shape/16.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                    <div class="shape18"><img src="<?php echo esc_url( STIKE_IMG .'/shape/17.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="subscribe-area bg-f4f5fe">
                <div class="container">
                    <div class="subscribe-content">
                        <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>

                        <form class="newsletter-form" method="post" action="<?php echo home_url(); ?>/?na=s" onsubmit="return newsletter_check(this)">
                            <div class="row align-items-center">
                                <div class="col-lg-8 col-md-8">
                                    <input type="email" name="ne" class="input-newsletter" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" required autocomplete="off">
                                </div>

                                <div class="col-lg-4 col-md-4">
                                    <?php if( $settings['button_text'] != '' ): ?>
                                        <button type="submit"><i class="bx bxs-hot"></i> <?php echo esc_html( $settings['button_text'] ); ?></button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </form>
                        
                        <?php if( $settings['show_shape'] == 'yes' ): ?>
                            <div class="shape14"><img src="<?php echo esc_url( STIKE_IMG .'/shape/13.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                            <div class="shape15"><img src="<?php echo esc_url( STIKE_IMG .'/shape/14.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                            <div class="shape16"><img src="<?php echo esc_url( STIKE_IMG .'/shape/15.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                            <div class="shape17"><img src="<?php echo esc_url( STIKE_IMG .'/shape/16.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                            <div class="shape18"><img src="<?php echo esc_url( STIKE_IMG .'/shape/17.png', 'stike-toolkit' ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php 
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Stike_Newsletter );