<?php
/**
 * FAQ Widget
 */

namespace Elementor;
class Stike_Faq extends Widget_Base {

	public function get_name() {
        return 'FAQ';
    }

	public function get_title() {
        return __( 'Stike FAQ', 'stike-toolkit' );
    }

	public function get_icon() {
        return 'eicon-help-o';
    }

	public function get_categories() {
        return [ 'stike-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Stike_Faq',
			[
				'label' => __( 'Faq Control', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'stike-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Get to know about Stike', 'stike-toolkit' ),
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __( 'Faq Image', 'stike-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
		
		$this->add_control(
            'faq_item',
            [
                'label' => esc_html__('Faq Item', 'stike-toolkit'),
                'type' => Controls_Manager::REPEATER,
                'separator' => 'before',
                'fields' => [
					[	
						'name'	=> 'title',
						'label' => __( 'Title', 'stike-toolkit' ),
						'type' => Controls_Manager::TEXT,
						'default' => __( 'How do permissions work in Google Play Instant?', 'stike-toolkit' ),
					],

                    [
						'name'	=> 'content',
						'label' => __( 'Description', 'stike-toolkit' ),
						'type' => Controls_Manager::TEXTAREA,
						'default' => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'stike-toolkit' ),
					],
                ],
            ]
        );
       
        $this->end_controls_section();

        $this->start_controls_section(
			'partner_style',
			[
				'label' => __( 'Style', 'stike-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_responsive_control(
            'title_size',
            [
                'label' => __( 'Title Font Size', 'stike-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 5,
                        'max' => 70,
                        'step' => 1,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-accordion h2' => 'font-size: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_control(
			'color',
			[
				'label' => __( 'Faq Background', 'stike-toolkit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .faq-accordion .accordion .accordion-title, .faq-accordion .accordion .accordion-content' => 'background-color: {{VALUE}}',
				],
			]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $faq_item = $settings['faq_item'];
        $i = 0;
        ?>
        <div class="faq-area ptb-100">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-lg-7 col-md-12">
                        <div class="faq-accordion">
                            <h2><?php echo $settings['title']; ?></h2>
                            <ul class="accordion">
                                <?php  foreach ( $faq_item as $key => $value ): ?>
                                    <?php if ( $i == 0 ): ?>
                                        <li class="accordion-item">
                                            <a class="accordion-title active" href="javascript:void(0)">
                                                <i class="bx bx-plus"></i>
                                                <?php echo esc_html( $value['title'] ); ?>
                                            </a>
                                            <p class="accordion-content" style="display: block;">
                                                <?php echo esc_html( $value['content'] ); ?>
                                            </p>
                                        </li>
                                    <?php else: ?>   
                                        <li class="accordion-item">
                                            <a class="accordion-title" href="javascript:void(0)">
                                                <i class="bx bx-plus"></i>
                                                <?php echo esc_html( $value['title'] ); ?>
                                            </a>
                                            <p class="accordion-content">
                                                <?php echo esc_html( $value['content'] ); ?>
                                            </p>
                                        </li>                       
                                    <?php endif; ?>                                
                                <?php $i++; endforeach; ?>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-5 col-md-12">
                        <div class="faq-image">
                            <?php if( $settings['image']['url'] != '' ): ?>
                                <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Stike_Faq );