<?php
/* 
 * Plugin Name: ابزار های قالب استایک
 * Author: وردپرس سریع
 * Author URI: envytheme.com
 * Description: A Light weight and easy toolkit for Sekia WordPress theme.
 * Version: 1.0.0
 */

if (!defined('ABSPATH')) {
    exit; //Exit if accessed directly
}

define('STIKE_ACC_PATH', plugin_dir_path(__FILE__));
if( !defined('STIKE_FRAMEWORK_VAR') ) define('STIKE_FRAMEWORK_VAR', 'stike_opt');

// Main Elementor stike Extension Class
final class Elementor_Stike_Extension {

	const VERSION = '1.0.0';
	const MINIMUM_ELEMENTOR_VERSION = '2.0.0';
	const MINIMUM_PHP_VERSION = '7.0';

	// Instance
    private static $_instance = null;
    
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	// Constructor
	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'init' ] );

	}

	// init
	public function init() {
        load_plugin_textdomain( 'stike-toolkit' );

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return;
		}

		// Add Plugin actions
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );
        
        add_action('elementor/elements/categories_registered',[ $this, 'register_new_category'] );
        
    }

    public function register_new_category($manager){
        $manager->add_category('stike-elements',[
            'title'=>esc_html__('stike','stike-toolkit'),
            'icon'=> 'fa fa-image'
        ]);
    }

	//Admin notice
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'stike-toolkit' ),
			'<strong>' . esc_html__( 'Stike Toolkit', 'stike-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'stike-toolkit' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'stike-toolkit' ),
			'<strong>' . esc_html__( 'Stike Toolkit', 'stike-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'stike-toolkit' ) . '</strong>',
			 self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'stike-toolkit' ),
			'<strong>' . esc_html__( 'Stike Toolkit', 'stike-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'stike-toolkit' ) . '</strong>',
			 self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	// Toolkit Widgets
	public function init_widgets() {

		// Include Widget files
		require_once( __DIR__ . '/widgets/banner.php' );
		require_once( __DIR__ . '/widgets/saas-banner.php' );
		require_once( __DIR__ . '/widgets/seo-banner.php' );
		require_once( __DIR__ . '/widgets/section.php' );
		require_once( __DIR__ . '/widgets/partner.php' );
		require_once( __DIR__ . '/widgets/services-area.php' );
		require_once( __DIR__ . '/widgets/services-area-two.php' );
		require_once( __DIR__ . '/widgets/watch-video.php' );
		require_once( __DIR__ . '/widgets/funfacts.php' );
		require_once( __DIR__ . '/widgets/contact-cta-box.php' );
		require_once( __DIR__ . '/widgets/single-features-box.php' );
		require_once( __DIR__ . '/widgets/feedback.php' );
		require_once( __DIR__ . '/widgets/pricing.php' );
		require_once( __DIR__ . '/widgets/faq.php' );
		require_once( __DIR__ . '/widgets/cta-area.php' );
		require_once( __DIR__ . '/widgets/team.php' );
		require_once( __DIR__ . '/widgets/overview-area.php' );
		require_once( __DIR__ . '/widgets/blog-posts.php' );
		require_once( __DIR__ . '/widgets/newsletter.php' );
		require_once( __DIR__ . '/widgets/download-app.php' );
		require_once( __DIR__ . '/widgets/about.php' );
		require_once( __DIR__ . '/widgets/contact-area.php' );
	}

}
Elementor_Stike_Extension::instance();

// Redux Theme Options
require_once(STIKE_ACC_PATH . 'redux/ReduxCore/framework.php');
require_once(STIKE_ACC_PATH . 'redux/sample/sample-config.php');
require_once(STIKE_ACC_PATH . 'inc/widgets.php');

//Registering crazy toolkit files
function stike_toolkit_files()
{
    wp_enqueue_style('font-awesome-4.7', plugin_dir_url(__FILE__) . 'assets/css/font-awesome.min.css');
}

add_action('wp_enqueue_scripts', 'stike_toolkit_files');

add_filter('the_content', 'stike_remove_empty_p', 20, 1);
function stike_remove_empty_p($content){
    $content = force_balance_tags($content);
    return preg_replace('#<p>\s*+(<br\s*/*>)?\s*</p>#i', '', $content);
}

add_filter('script_loader_tag', 'stike_clean_script_tag');
function stike_clean_script_tag($input) {
        $input = str_replace( array( 'type="text/javascript"', "type='text/javascript'" ), '', $input );
        return $input;
}

/**
 * Extend Icon pack core controls.
 *
 * @param  object $controls_manager Controls manager instance.
 * @return void
 */ 

function stike_icon_pack( $controls_manager ) {

	require_once(STIKE_ACC_PATH . 'inc/icon.php');

	$controls = array(
		$controls_manager::ICON => 'STIKE_Icon_Controler',
	);

	foreach ( $controls as $control_id => $class_name ) {
		$controls_manager->unregister_control( $control_id );
		$controls_manager->register_control( $control_id, new $class_name() );
	}
}
function stike_jquery_version() {
    wp_deregister_script( 'jquery' );
	wp_register_script( 'jquery', plugin_dir_url(__FILE__) . 'assets/js/jquery-2.1.4.min.js', array(), '2.1.4' );
}
add_action( 'wp_enqueue_scripts', 'stike_jquery_version' );

// Post Category Select
function stike_toolkit_get_post_cat_list() {
	$post_category_id = get_queried_object_id();
	$args = array(
		'parent' => $post_category_id
	);

	$terms = get_terms( 'category', get_the_ID());
	$cat_options = array(esc_html__('', 'stike-toolkit') => '');

	if ($terms) {
		foreach ($terms as $term) {
			$cat_options[$term->name] = $term->name;
		}
	}
	return $cat_options;
}

// Select page for link
function stike_toolkit_get_page_as_list() {
    $args = wp_parse_args(array(
        'post_type' => 'page',
        'numberposts' => -1,
    ));

    $posts = get_posts($args);
    $post_options = array(esc_html__('', 'stike-toolkit') => '');

    if ($posts) {
        foreach ($posts as $post) {
            $post_options[$post->post_title] = $post->ID;
        }
    }
    $flipped = array_flip($post_options);
    return $flipped;
}

$opt_name = STIKE_FRAMEWORK_VAR;