<?php
/**
 * @author Jegtheme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'JNews_Migration_JMagz_Dashboard' ) ) {
	class JNews_Migration_JMagz_Dashboard {

		/**
		 * @var JNews_Migration_JMagz_Dashboard
		 */
		private static $instance;

		/**
		 * Register Location
		 *
		 * @var array
		 */
		private $register_location = array(
			'toplevel_page_jnews',
		'appearance_page_jnews',
		);

		/**
		 * @return JNews_Migration_JMagz_Dashboard
		 */
		public static function getInstance() {
			if ( null === static::$instance ) {
				static::$instance = new static();
			}
			return static::$instance;
		}

		/**
		 * JNews_Migration_JMagz_Dashboard constructor
		 */
		private function __construct() {
			add_action( 'admin_enqueue_scripts', array( $this, 'load_assets' ) );
			add_filter( 'jnews_admin_menu', array( $this, 'admin_menu' ) );
			add_filter( 'jnews_admin_slug', array( $this, 'admin_slug' ) );
		}

		/**
		 * Load plugins css and js assets
		 *
		 * @param string $hook The current admin page.
		 */
		public function load_assets( $hook ) {
			wp_register_style( 'jnews-migration-jmagz-style', JNEWS_MIGRATION_JMAGZ_URL . '/assets/css/plugin.css', null, JNEWS_MIGRATION_JMAGZ_VERSION );
			wp_enqueue_style( 'jnews-migration-jmagz-style' );

			wp_register_script( 'jnews-migration-jmagz-script', JNEWS_MIGRATION_JMAGZ_URL . '/assets/js/plugin.js', null, JNEWS_MIGRATION_JMAGZ_VERSION );
			wp_enqueue_script( 'jnews-migration-jmagz-script' );

			if ( in_array( $hook, $this->register_location, true ) ) {
				$include = include JNEWS_MIGRATION_JMAGZ_DIR . '/lib/dependencies/migration-dashboard.asset.php';
				wp_enqueue_script(
					'migration-dashboard',
					JNEWS_MIGRATION_JMAGZ_URL . '/assets/js/admin/migration-dashboard.js',
					$include['dependencies'],
					JNEWS_MIGRATION_JMAGZ_VERSION,
					true
				);
				wp_localize_script(
					'migration-dashboard',
					'JNewsMigration_jmagz',
					self::jnews_dashboard()
				);
				wp_set_script_translations( 'migration-dashboard', 'jnews-migration-jmagz', JNEWS_MIGRATION_JMAGZ_LANG_DIR );

				wp_enqueue_style(
					'migration-dashboard',
					JNEWS_MIGRATION_JMAGZ_URL . '/assets/css/admin/migration-dashboard.css',
					null,
					JNEWS_MIGRATION_JMAGZ_VERSION
				);
			}
		}

		/**
		 * Set migration dashboard menu
		 *
		 * @param  array $menu
		 *
		 * @return array
		 */
		public function admin_menu( $menu ) {
			$admin_url = defined( 'JNEWS_ESSENTIAL' ) ? 'admin.php' : 'themes.php';
			$slug = apply_filters( 'jnews_get_admin_slug', '' );

			$revert_dashboard = apply_filters( 'jnews_revert_dashboard', false );

			$migration_menu = array(
				array(
					'title'        => esc_html__( 'Migration - JMagz', 'jnews-migration-jmagz' ),
					'menu'         => esc_html__( 'Migration - JMagz', 'jnews-migration-jmagz' ),
					'slug'         => $revert_dashboard ? $slug['dashboard'] : $slug['dashboard'] . '&path=' . $slug['migration_jmagz'],
					'action'       => $revert_dashboard ? array( &$this, 'migration_jmagz' ) : admin_url( $admin_url . '?page=jnews&path=' . $slug['migration_jmagz'] ),
					'priority'     => 59,
					'show_on_menu' => true,
					'plugin'       => true,
				),
			);

			return array_merge( $menu, $migration_menu );
		}

		public function admin_slug( $slug ) {
			$translation_slug = array(
				'migration_jmagz' => 'jnews_migration_jmagz',
			);

			return array_merge( $translation_slug, $slug );
		}

		/**
		 * Render migration dashboard template
		 */
		public function migration_jmagz() {
			require_once 'template/migration-dashboard.php';
		}

		/**
		 * JNews Dashboard Config
		 *
		 * @return array
		 */
		public static function jnews_dashboard() {
			$config           = array();
			$migration        = JNews_Migration_JMagz::getInstance();
			$config['count']  = (int) $migration->content_migration( true );
			$config['review'] = $migration->review_plugin_check();
			return $config;
		}

	}
}

