<?php
/**
 * @author : Jegtheme
 */

use JNews\Module\Block\BlockViewAbstract;
use JNews\WEBSTORIES\Module\Module_Query;

/**
 * JNews_Element_Webstories_View
 */
class JNews_Element_Webstories_View extends BlockViewAbstract {

	/**
	 * Name
	 *
	 * @var string
	 */

	private $name = 'webstories';
	/**
	 * Story Item type
	 *
	 * @var mixed
	 */

	private $type;
	/**
	 * Unseen border color
	 *
	 * @var mixed
	 */

	private $solid_border_color;
	/**
	 * Show Author
	 *
	 * @var mixed
	 */

	private $show_author;
	/**
	 * Show Bordee
	 *
	 * @var mixed
	 */
	private $show_border;

	/**
	 * Show Overlay
	 *
	 * @var mixed
	 */
	private $show_overlay;

	/**
	 * Show Navigation
	 *
	 * @var mixed
	 */
	private $show_controls;

	/**
	 * Show Navigation
	 *
	 * @var mixed
	 */
	private $border_radius;


	/**
	 * Get module name
	 *
	 * @return mixed|string
	 */
	public function get_name() {
		return $this->name;
	}

	/**
	 * Border style
	 *
	 * @var mixed|string
	 */
	private $border_style;

	/**
	 * Show title
	 *
	 * @var mixed|string
	 */
	private $show_title;

	/**
	 * Border gradient degree
	 *
	 * @var mixed|string
	 */
	private $border_gradient_degree;

	/**
	 * Border gradient start color
	 *
	 * @var mixed|string
	 */
	private $border_gradient_start_color;

	/**
	 * Number post
	 *
	 * @var integer
	 */
	private $number_post;


	/**
	 * Default desktop visibile item
	 *
	 * @var integer
	 */
	private $visible_item;

	/**
	 * Border gradient end color
	 *
	 * @var mixed|string
	 */
	private $border_gradient_end_color;

	/**
	 * Potrait style
	 *
	 * @var mixed|string
	 */
	private $potrait_style;

	/**
	 * Column Width
	 *
	 * @var mixed|string
	 */
	private $column_width;

	/**
	 * Build query
	 *
	 * @param array $attr query attribute.
	 *
	 * @return array|int|string|\WP_Error
	 */
	protected function build_query( $attr ) {
		if ( in_array( $this->get_name(), array( 'webstories' ), true ) ) {
			return Module_Query::webstories_query( $attr );
		}
	}

	public function assets_loader() {
		if ( ! is_user_logged_in() ) {
			if ( ( SCRIPT_DEBUG || get_theme_mod( 'jnews_load_necessary_asset', false ) ) ) {
				wp_dequeue_style( 'jnews-scheme' );
			}
			wp_enqueue_style( 'jnews-webstories' );
			wp_enqueue_script( 'jnews-webstories' );
			if ( ( SCRIPT_DEBUG || get_theme_mod( 'jnews_load_necessary_asset', false ) ) ) {
				wp_enqueue_style( 'jnews-scheme' );
			}
		}
	}

	/**
	 * Render module
	 *
	 * @param array  $attr elemnt attribute.
	 * @param string $column_class element class.
	 *
	 * @return string
	 */
	public function render_module( $attr, $column_class ) {
		$this->assets_loader();
		$this->column_width                = $this->manager->get_current_width();
		$this->number_post                 = isset( $attr['number_post'] ) ? $attr['number_post'] : 0;
		$this->webstories_item             = isset( $attr['webstories_item'] ) ? explode( ',', $attr['webstories_item'] ) : array();
		$this->type                        = isset( $attr['item_type'] ) ? $attr['item_type'] : '';
		$this->show_border                 = isset( $attr['show_border'] ) ? $attr['show_border'] : false;
		$this->show_overlay                = $attr['show_overlay'] ? 'overlay' : '';
		$this->show_author                 = 'true' === $attr['show_author'] ? true : false;
		$this->show_title                  = isset( $attr['show_title'] ) ? $attr['show_title'] : true;
		$disable_tile_class                = ! $this->show_title ? 'disable_tile' : '';
		$this->border_style                = isset( $attr['border_style'] ) ? $attr['border_style'] : 'solid';
		$this->solid_border_color          = isset( $attr['solid_border_color'] ) && ! empty( $attr['solid_border_color'] ) ? $attr['solid_border_color'] : '';
		$this->border_gradient_degree      = isset( $attr['border_gradient_degree']['size'] ) ? $attr['border_gradient_degree']['size'] : $attr['border_gradient_degree'];
		$this->border_gradient_start_color = $attr['border_gradient_start_color'] ? $attr['border_gradient_start_color'] : '#F12711';
		$this->border_gradient_end_color   = $attr['border_gradient_end_color'] ? $attr['border_gradient_end_color'] : '#F5AF19';
		$this->border_radius               = isset( $attr['border_radius']['size'] ) ? $attr['border_radius']['size'] : $attr['border_radius'];
		$number_item                       = isset( $attr['number_item']['size'] ) ? $attr['number_item']['size'] : $attr['number_item'];
		$potrait_number_item               = isset( $attr['potrait_number_item']['size'] ) ? $attr['potrait_number_item']['size'] : $attr['potrait_number_item'];
		$this->visible_item                = 'potrait' === $this->type || 'grid' === $this->type ? $potrait_number_item : $number_item;
		$this->show_controls               = $this->show_controls( $attr['show_controls'] );
		$this->potrait_style               = isset( $attr['potrait_style'] ) ? $attr['potrait_style'] : 'style_1';

		$el_class   = isset( $attr['el_class'] ) ? $attr['el_class'] : '';
		$content    = $this->render_output( $attr, $column_class );
		$script     = $this->render_script( $attr, $column_class );
		$pagination = isset( $attr['pagination_mode'] ) ? 'jeg_pagination_' . $attr['pagination_mode'] : '';

		return "<div {$this->element_id($attr)} data-visible-item=\"{$this->visible_item}\" class=\"jnews-webstories-slider {$this->type} {$this->potrait_style} {$this->show_controls} {$disable_tile_class} jeg_slider_wrapper jeg_postblock_{$this->get_name()} jeg_postblock jeg_module_hook $pagination {$column_class} {$this->unique_id} {$this->get_vc_class_name()} {$el_class}\" data-unique=\"{$this->unique_id}\">
					{$content}
					{$script}
				</div>";
	}


	/**
	 * Render output
	 *
	 * @param array  $attr element attribute.
	 * @param string $column_class element calss.
	 *
	 * @return string
	 */
	public function render_output( $attr, $column_class ) {
		if ( isset( $attr['results'] ) ) {
			$results = $attr['results'];
		} else {
			$results = $this->build_query( $attr );
		}

		if ( ! empty( $results ) && isset( $results['result'] ) && ! empty( $results['result'] ) ) {
			// sort story by unseen.
			$this_seen_stories = array();
			if ( ! empty( $_COOKIE['jnews-webstories'] ) ) {
				$cookies_seen_stories = json_decode( wp_unslash( sanitize_text_field( $_COOKIE['jnews-webstories'] ) ) ); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
				foreach ( $results['result'] as $key => $item ) {
					if ( in_array( $item->ID, $cookies_seen_stories, false ) ) {
						$this_seen_stories[] = $item;
						unset( $results['result'][ $key ] );
					}
				}
			}
			$results['result'] = array_merge( $results['result'], $this_seen_stories );
			$content           = $this->render_column( $results['result'], $column_class );
		} else {
			$content = $this->empty_content();
		}

		return "<div class=\"jeg_block_container\">
                {$this->get_content_before($attr)}
                {$content}
                {$this->get_content_after($attr)}
            </div>";
	}

	/**
	 * Render Column
	 *
	 * @param  mixed $results query results.
	 * @param  mixed $column_class element class.
	 * @return string
	 */
	public function render_column( $results, $column_class ) {

		$rtl                           = is_rtl() ? 'rtl' : '';
		$unique_class                  = trim( $this->unique_id );
		$potrait_overlay_border_radius = $this->border_radius - 1 > 1 ? $this->border_radius - 1 : 0;
		$border_radius                 = ".jnews-webstories-slider.potrait .{$unique_class} .story .jeg_thumb, 
										.jnews-webstories-slider.grid .{$unique_class} .story .jeg_thumb, 
										.jnews-webstories-slider.potrait .{$unique_class} .story .jeg_thumb .thumbnail-container, 
										.jnews-webstories-slider.grid .{$unique_class} .story .jeg_thumb .thumbnail-container,
										.jnews-webstories-slider.potrait .{$unique_class} .story .jeg_thumb .thumbnail-container img, 
										.jnews-webstories-slider.grid .{$unique_class} .story .jeg_thumb .thumbnail-container img, 
										.jnews-webstories-slider.potrait .{$unique_class} .item-preview .jeg_thumb div.thumbnail-container.no_thumbnail:after,
										.jnews-webstories-slider.grid .{$unique_class} .item-preview .jeg_thumb div.thumbnail-container.no_thumbnail:after { border-radius: {$this->border_radius}px;} 
										.jnews-webstories-slider.potrait .{$unique_class} .story .jeg_thumb.overlay .thumbnail-container:before,
										.jnews-webstories-slider.grid .{$unique_class} .story .jeg_thumb.overlay .thumbnail-container:before { border-radius: {$potrait_overlay_border_radius}px; }";
		$border_color                  = 'solid' === $this->border_style ? "{$this->solid_border_color}" : "linear-gradient({$this->border_gradient_degree}deg, {$this->border_gradient_start_color} 0%, {$this->border_gradient_end_color} 100%)";
		$border_style                  = 'potrait' !== $this->type && 'grid' !== $this->type ? ".jnews-webstories.{$unique_class} .story .jnews-webstories-item .jeg_thumb {background: {$border_color}; }" : '';
		$author_border_style           = $this->show_author ? ".jnews-webstories-slider.potrait.style_1 .jnews-webstories.{$unique_class} .story .item-avatar, .jnews-webstories-slider.grid.style_1 .jnews-webstories.{$unique_class} .story .item-avatar {background: {$border_color};}" : '';
		$seen_border_color             = ".jnews-webstories.{$unique_class} .story .jnews-webstories-item.seen .jeg_thumb, 
										 .jnews-webstories-slider.potrait.style_1 .jnews-webstories.{$unique_class} .story .jnews-webstories-item.seen .item-avatar, 
										 .jnews-webstories-slider.grid.style_1 .jnews-webstories.{$unique_class} .story .jnews-webstories-item.seen .item-avatar {background: #e5e5e5;}";
		$style                         = "<style scoped>
											.jnews-webstories.{$unique_class} .thumbnail-container.no_thumbnail {display: block !important;} 
											{$border_style} 
											{$seen_border_color} 
											{$border_radius} 
											{$author_border_style }
										</style>";
		$is_carousel                   = 'list' !== $this->type ? 'carousel' : 'vemdezap';

		$first_block = '';
		for ( $i = 0, $i_max = count( $results ); $i < $i_max; $i++ ) {
			$first_block .= $this->render_block( $results[ $i ], $i );
		}
		$last_block = $this->render_block( array(), null ); // need to add dummy last item to prevent the real last item got cropped on tiny slider.

		return "<div class=\"jeg_posts_wrap\">
					<div class=\"jeg_posts\"> 
					<div data-visible-item=\"{$this->visible_item}\" class='jnews-webstories jeg_col_{$this->column_width} {$this->show_controls} jeg_load_more_flag {$unique_class} {$rtl} {$this->type} {$is_carousel}'>{$first_block}{$last_block}</div>{$style}
					</div>
				</div>";
	}

	/**
	 * Render column alt
	 *
	 * @param array  $results query results.
	 * @param string $column_class element class.
	 *
	 * @return string
	 */
	public function render_column_alt( $results, $column_class ) {
		$first_block = '';
		for ( $i = 0, $i_max = count( $results ); $i < $i_max; $i++ ) {
			$first_block .= $this->render_block_alt( $results[ $i ], $i );
		}

		return $first_block;
	}

	/**
	 * Render block
	 *
	 * @param WP_Term $story story object.
	 * @param int     $index array index.
	 *
	 * @return string
	 */
	public function render_block( $story = array(), $index = null ) {
		if ( ! empty( $story ) && null !== $index ) {
			++$index;
			$rtl          = is_rtl() ? 'rtl' : '';
			$border_class = $this->show_border ? 'item-border' : '';
			return "<div class='story'>
						<span class='item-link  jnews-webstories-item {$rtl} {$border_class}' data-id={$story->ID} data-index='{$index}' title='{$story->post_title}'>
							" . $this->layout( $story ) . '
						</span>
					</div>';
		}
	}

	/**
	 * Render block alt
	 *
	 * @param WP_Term $story story object.
	 * @param int     $index array index.
	 *
	 * @return string
	 */
	public function render_block_alt( $story, $index ) {
		if ( ! empty( $story ) ) {
			$rtl          = is_rtl() ? 'rtl' : '';
			$border_class = $this->show_border ? 'item-border' : '';
			return "<div class='story'>
						<span class='item-link  jnews-webstories-item {$rtl} {$border_class}' data-id={$story->ID} data-index='{$index}' title='{$story->post_title}'>
							" . $this->layout( $story ) . '
						</span>
					</div>';
		}
	}

	/**
	 * Show Controls
	 *
	 * @param bool $is_show_control show control option.
	 *
	 * @return string
	 */
	public function show_controls( $is_show_control = false ) {
		$controls_class = '';
		if ( $is_show_control ) {
			if ( 'circle' === $this->type && $this->visible_item <= $this->number_post || 'square' === $this->type && $this->visible_item <= $this->number_post ) {
				$controls_class = 'show-controls';
			} elseif ( 'potrait' === $this->type && $this->visible_item < $this->number_post ) {
				$controls_class = 'show-controls';
			}
		}
		return $controls_class;
	}

	/**
	 * Item layout type
	 *
	 * @param  mixed $story story object.
	 * @return string
	 */
	public function layout( $story ) {
		$author            = '';
		$show_author_class = '';
		$author            = '';
		$thumbnail         = '';
		$story_info        = '';
		$title             = $this->show_title || 'list' === $this->type ? "<h3 class=\"jeg_post_title\"><a class=\"name\" itemprop=\"name\">{$story->post_title}</a></h3>" : ''; //see #R0H4gBX2
		if ( 'potrait' === $this->type || 'grid' === $this->type ) {
			$thumbnail = $this->get_thumbnail( $story->ID, 'jnews-360x504' );
			if ( 'style_1' === $this->potrait_style ) {
				if ( $this->show_author ) {
					$show_author_class = 'author';
					$author            = '<div class="item-avatar">' . get_avatar( $story->post_author ) . '</div>';
				}
				$story_info = $author . $title;
			} elseif ( 'style_2' === $this->potrait_style ) {
				if ( $this->show_author ) {
					$show_author_class = 'author';
					$author            = '<div class="item-avatar"><span><a>' . jnews_return_translation( 'by', 'jnews-webstories', 'by' ) . ' ' . get_the_author_meta( 'display_name', $story->post_author ) . '</a></span></div>';
				}
				$story_info = $title . $author;
			}
		} else {
			$thumbnail  = $this->get_thumbnail( $story->ID, 'jnews-350x350' );
			$story_info = $title;
		}

		return "<span class='item-preview' >
					<div class='jeg_thumb {$this->show_overlay}'>
						{$thumbnail}
					</div>
				</span>
				<span class='info {$show_author_class}' itemprop='author' itemscope='' itemtype='http://schema.org/Person'>
					{$story_info}
				</span>";
	}
}
