<?php
/**
 * @author : Jegtheme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Theme JNews_Post_Split
 */
class JNews_Split_Type_2 extends JNews_Split_Type_Abstract {

	public function render() {
		$output  = $this->before_content;
		$output .= "<div class='top-split-nav'>" . $this->drop_section() . '</div>';
		$output .= $this->render_content();
		$output .= $this->drop_section();
		$output .= $this->bottom_nav();

		return $output;
	}

	public function drop_section() {
		$output =
			'<div class="jeg_splitpost_bar jeg_splitpost_2">
                <div class="nav_wrap">
                    ' . $this->current_title() . '
                    ' . $this->split_post_nav() . '
                </div>
            </div>';

		return $output;
	}

	public function bottom_nav() {
		$previous_class = $previous_title = $previous_url = '';
		$next_class     = $next_title = $next_url = '';
		$previous_index = $next_index = 0;

		// previous title
		if ( isset( $this->all_title[ $this->index - 1 ] ) ) {
			$previous_title = $this->all_title[ $this->index - 1 ];
			$previous_url   = $this->get_page_link_url( $this->current_page - 1 );
			$previous_index = $this->index - 1;
		}

		// next title
		if ( isset( $this->all_title[ $this->index + 1 ] ) ) {
			$next_title = $this->all_title[ $this->index + 1 ];
			$next_url   = $this->get_page_link_url( $this->current_page + 1 );
			$next_index = $this->index + 1;
		}

		// hide previous element
		if ( $this->index === 0 ) {
			$previous_class = 'hide';
		}

		// hide next element
		if ( $this->current_page === $this->max_page ) {
			$next_class = 'hide';
		}

		$previous =
			"<div class=\"page_nav prev {$previous_class}\">
                <a href=\"{$previous_url}\">
                    <span>" . jnews_return_translation( 'Previous', 'jnews-split', 'previous' ) . "</span>
                    <strong>{$previous_title}</strong>
                </a>
            </div>";

		$next =
			"<div class=\"page_nav next {$next_class}\">
                <a href=\"{$next_url}\">
                    <span>" . jnews_return_translation( 'Next', 'jnews-split', 'next' ) . "</span>
                    <strong>{$next_title}</strong>
                </a>
            </div>";

		$output =
			"<div class=\"jeg_bottomnav clearfix\">
                <div class=\"pagenav_wrap\">
                    {$previous}
                    {$next}
                </div>
            </div>";

		return $output;
	}

	public function get_split_type() {
		return '2';
	}
}

