<?php

/**
* Template for theme dashboard welcome page
*/
?>
<div class="arter-dashboard-help">
  <div class="image-container">
    <script src="https://unpkg.com/@lottiefiles/lottie-player@latest/dist/lottie-player.js"></script>
    <lottie-player src="https://assets2.lottiefiles.com/packages/lf20_amiibtte.json"  background="transparent"  speed="1"  style="width: 100%; height: auto;"  loop  autoplay></lottie-player>
  </div>
  <div class="content-container">
    <h2><?php echo esc_html__( 'Help Center & Support', 'arter-plugin' ); ?></h2>
    <p><?php echo sprintf( __( 'Here you can find some usefull links and information. Didn\'t find what you were looking for. Please check our <a href="%s" target="_blank">official website</a> and product page on <a href="%s" target="_blank">Envato Market</a>.', 'arter-plugin' ),  'https://mimwp.com/theme/arter/', 'https://www.zhaket.com/web/arter-cv-resume-wordpress-theme' ); ?></p>
    <div class="arter-dashboard-list">
      <ul>
        <li>
          <h4><span class="dashicons dashicons-admin-settings"></span> <?php echo esc_html__( 'Theme Settings', 'arter-plugin' ); ?></h4>
          <p><?php echo esc_html__( 'Customize the appearance of your theme and configure global theme settings.', 'arter-plugin' ); ?></p>
          <p><a href="<?php echo admin_url( 'admin.php?page=theme-options' ); ?>"><?php echo esc_html__( 'Go to Theme Settings', 'arter-plugin' ); ?></a></p>
          <p>&nbsp;</p>
        </li>

        <li>
          <h4><span class="dashicons dashicons-book"></span> <?php echo esc_html__( 'Documentation', 'arter-plugin' ); ?></h4>
          <p><?php echo esc_html__( 'Having questions? Learn our detailed instructions how to install and customize themes with fast video guides.', 'arter-plugin' ); ?></p>
          <p><a href="https://mimwp.com/theme/arter/doc/" target="_blank"><?php echo esc_html__( 'Go to Documentation', 'arter-plugin' ); ?></a></p>
          <p>&nbsp;</p>
        </li>

        <li>
          <h4><span class="dashicons dashicons-sos"></span> <?php echo esc_html__( '24/7 Support', 'arter-plugin' ); ?></h4>
          <p><?php echo esc_html__( 'Have some problems and need help? Don\'t worry, you can always submit a support ticket, and our team will help you resolve any issues.', 'arter-plugin' ); ?></p>
          <p><a href="https://www.zhaket.com/dashboard/tickets/new" target="_blank"><?php echo esc_html__( 'Submit a ticket', 'arter-plugin' ); ?></a></p>
          <p>&nbsp;</p>
          
        </li>
      </ul>
    </div>
  </div>
</div>
