<?php

/**
 * Plugin Name: افزودنی ووکامرس YITH برند محصولات پرمیوم
 * Plugin URI: https://wpfast.ir/product/yith-woocommerce-brands-add-on-premium/
 * Description: افزونه YITH  برند ووکامرس به شما امکان می دهد عملکرد برندها را به ووکامرس اضافه کنید.
 * Version: 1.13.0
 * Author: وردپرس سریع
 * Author URI: https://wpfast.ir
 * Text Domain: yith-woocommerce-brands-add-on
 * Domain Path: /languages/
 * WC requires at least: 5.0.0
 * WC tested up to: 5.9
 *
 * @author Your Inspiration Themes
 * @package YITH WooCommerce Brands Add-on
 * @version 1.0.0
 */

/*
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */
if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

if (!function_exists('yith_plugin_registration_hook')) {
	require_once 'plugin-fw/yit-plugin-registration-hook.php';
}
register_activation_hook(__FILE__, 'yith_plugin_registration_hook');

if (!defined('YITH_WCBR')) {
	define('YITH_WCBR', true);
}

if (!defined('YITH_WCBR_VERSION')) {
	define('YITH_WCBR_VERSION', '1.3.10');
}

if (!defined('YITH_WCBR_URL')) {
	define('YITH_WCBR_URL', plugin_dir_url(__FILE__));
}

if (!defined('YITH_WCBR_DIR')) {
	define('YITH_WCBR_DIR', plugin_dir_path(__FILE__));
}

if (!defined('YITH_WCBR_INC')) {
	define('YITH_WCBR_INC', YITH_WCBR_DIR . 'includes/');
}

if (!defined('YITH_WCBR_INIT')) {
	define('YITH_WCBR_INIT', plugin_basename(__FILE__));
}

if (!defined('YITH_WCBR_SECRET_KEY')) {
	define('YITH_WCBR_SECRET_KEY', '03CgkyQ8Lb3iXrkPzi6t');
}

if (!defined('YITH_WCBR_SLUG')) {
	define('YITH_WCBR_SLUG', 'yith-woocommerce-brands-add-on');
}

if (!defined('YITH_WCBR_PREMIUM_INIT')) {
	define('YITH_WCBR_PREMIUM_INIT', plugin_basename(__FILE__));
}

/* Plugin Framework Version Check */
if (!function_exists('yit_maybe_plugin_fw_loader') && file_exists(YITH_WCBR_DIR . 'plugin-fw/init.php')) {
	require_once(YITH_WCBR_DIR . 'plugin-fw/init.php');
}
yit_maybe_plugin_fw_loader(YITH_WCBR_DIR);

if (!function_exists('yith_brands_constructor')) {
	function yith_brands_constructor()
	{
		load_plugin_textdomain('yith-woocommerce-brands-add-on', false, dirname(plugin_basename(__FILE__)) . '/languages/');

		require_once(YITH_WCBR_INC . 'functions.yith-wcbr.php');
		require_once(YITH_WCBR_INC . 'class.yith-wcbr.php');
		require_once(YITH_WCBR_INC . 'class.yith-wcbr-shortcode.php');
		require_once(YITH_WCBR_INC . 'class.yith-wcbr-shortcode-premium.php');
		require_once(YITH_WCBR_INC . 'class.yith-wcbr-premium.php');
		require_once(YITH_WCBR_INC . 'class.yith-wcbr-ajax-handler.php');

		// Let's start the game
		YITH_WCBR_Premium();

		if (is_admin()) {
			require_once(YITH_WCBR_INC . 'class.yith-wcbr-admin.php');
			require_once(YITH_WCBR_INC . 'class.yith-wcbr-admin-premium.php');

			YITH_WCBR_Admin_Premium();
		}
	}
}
add_action('yith_wcbr_init', 'yith_brands_constructor');

if (!function_exists('yith_brands_install')) {
	function yith_brands_install()
	{

		if (!function_exists('is_plugin_active')) {
			require_once(ABSPATH . 'wp-admin/includes/plugin.php');
		}

		if (!function_exists('yit_deactive_free_version')) {
			require_once 'plugin-fw/yit-deactive-plugin.php';
		}
		yit_deactive_free_version('YITH_WCBR_FREE_INIT', plugin_basename(__FILE__));

		if (!function_exists('WC')) {
			add_action('admin_notices', 'yith_wcbr_install_woocommerce_admin_notice');
		} else {
			do_action('yith_wcbr_init');
		}
	}
}
add_action('plugins_loaded', 'yith_brands_install', 11);

if (!function_exists('yith_wcbr_install_woocommerce_admin_notice')) {
	function yith_wcbr_install_woocommerce_admin_notice()
	{
?>
		<div class="error">
			<p><?php echo sprintf(__('%s is enabled but not effective. It requires WooCommerce in order to work.', 'yith-woocommerce-brands-add-on'), 'YITH WooCommerce Brands Add-on'); ?></p>
		</div>
	<?php
	}
}

if (!function_exists('yith_wcbr_install_free_admin_notice')) {
	function yith_wcbr_install_free_admin_notice()
	{
	?>
		<div class="error">
			<p><?php echo sprintf(__('You can\'t activate the free version of %s while you are using the premium one.', 'yith-woocommerce-brands-add-on'), 'YITH WooCommerce Brands Add-on'); ?></p>
		</div>
<?php
	}
}

