<?php
/**
 * @var YITH_WCBK_Service $service the booking service
 */

?>

	<tr class="form-field yith-wcbk-edit-service-title">
		<th scope="row" valign="top" colspan="2">
			<h3><?php echo __( 'WPML translations', 'yith-booking-for-woocommerce' ); ?></h3>
		</th>
	</tr>

<?php
$fields = array();

foreach ( $languages as $language_code => $language ) {
	$language_name     = isset( $language['display_name'] ) ? $language['display_name'] : $language_code;
	$name_name         = "yith_booking_service_data[wpml_translated_name][{$language_code}]";
	$description_name  = "yith_booking_service_data[wpml_translated_description][{$language_code}]";
	$value_name        = isset( $service->wpml_translated_name[ $language_code ] ) ? $service->wpml_translated_name[ $language_code ] : '';
	$value_description = isset( $service->wpml_translated_description[ $language_code ] ) ? $service->wpml_translated_description[ $language_code ] : '';
	?>

	<tr class="form-field yith-wcbk-edit-service-subtitle">
		<th scope="row" valign="top" colspan="2">
			<h4><?php echo $language_name; ?></h4>
		</th>
	</tr>

	<tr class="form-field">
		<th scope="row" valign="top">
			<label for="yith_booking_service_wpml_translated_name_<?php echo $language_code; ?>"><?php echo __( 'Name', 'yith-booking-for-woocommerce' ); ?></label>
		</th>
		<td>
			<input type="text" name="<?php echo $name_name; ?>"
					id="yith_booking_service_wpml_translated_name_<?php echo $language_code; ?>"
					value="<?php echo $value_name ?>"/>
		</td>
	</tr>

	<tr class="form-field">
		<th scope="row" valign="top">
			<label for="yith_booking_service_wpml_translated_description_<?php echo $language_code; ?>"><?php echo __( 'Description', 'yith-booking-for-woocommerce' ); ?></label>
		</th>
		<td>
            <textarea type="text" name="<?php echo $description_name; ?>"
					id="yith_booking_service_wpml_translated_description_<?php echo $language_code; ?>"><?php echo $value_description ?></textarea>
		</td>
	</tr>

	<?php
}
?>