<?php
class Persian_Yith_Woocommerce_Booking
{
	public static $instance = NULL;

	public static function get_instance()
	{
		NULL === self::$instance and self::$instance = new self;
		return self::$instance;
	}

	public function __construct() {
		add_action('admin_enqueue_scripts', [$this, 'admin_enqueue_scripts']);
		add_action('wp_enqueue_scripts', [$this, 'wp_enqueue_scripts']);
//        add_filter('yith_wcbk_ajax_booking_data_request', [$this, 'yith_wcbk_ajax_booking_data_request']);
//        add_filter('yith_wcbk_cart_booking_data_request', [$this, 'yith_wcbk_ajax_booking_data_request']);
//        add_filter('yith_wcbk_ajax_booking_available_times_request', [$this, 'yith_wcbk_ajax_booking_data_request']);

		add_filter('yith_wcbk_product_get_not_available_dates', [$this, 'yith_wcbk_product_get_not_available_dates'], 10, 3);
	}

	public function admin_enqueue_scripts() {
		wp_enqueue_style('persian-yith-booking-admin-style', YITH_WCBK_URL . 'persian/assets/admin.css', array(), YITH_WCBK_VERSION);
		wp_enqueue_script('persian-yith-booking-persian-date-script', YITH_WCBK_URL . 'persian/assets/persian-date.min.js', array('jquery'), YITH_WCBK_VERSION, true);

	}

	public function wp_enqueue_scripts() {
		wp_enqueue_script('persian-yith-booking-persian-date-script', YITH_WCBK_URL . 'persian/assets/persian-date.min.js', array('jquery'), YITH_WCBK_VERSION, true);

	}

	public function yith_wcbk_ajax_booking_data_request($request) {
		$to_check_array = ['from', 'to', 'start-date', 'end-date', 'yith-wcbk-booking-start-date-'.$request['add-to-cart'].'--formatted', 'yith-wcbk-booking-end-date-'.$request['add-to-cart'].'--formatted'];
		foreach($to_check_array as $k => $field) {
			if ( isset( $request[ $field ] ) and !empty($request[ $field ]) ) {
				$value       = explode( '-', $request[ $field ] );
				if(count($value) > 1) {
					$year  = $value[0];
					$month = $value[1];
					$day   = $value[2];
					if ( isset( $year, $month, $day ) and ! empty( $year ) and ! empty( $month ) and ! empty( $day ) ) {
						$timestamp = Persian_Yith_Woocommerce_Booking_jDate::get_instance()->jmktime( 0, 0, 0, $month, $day, $year );
						$value      = date( 'Y/m/d', $timestamp );
					}
				} else {
					$value = $request['from'];
				}
				$request[$field] = $value;
			}
		}
        return $request;
    }

    public function yith_wcbk_product_get_not_available_dates($dates, $args, $that) {
		if(!isset($dates) or empty($dates)) return $dates;
	    $result = [];
	    foreach($dates as $key => $date) {
		    $date       = explode( '-', $date );
		    $date       = Persian_Yith_Woocommerce_Booking_jDate::get_instance()->gregorian_to_jalali($date[0], $date[1], $date[2], '-');
		    $date       = explode('-', $date);
		    $result[]   = $date[0] . '-0' . $date[1] . '-' . $date[2];
		}
	    return $result;
    }
}