jQuery(document).ready(function () {
    jQuery('#upload_wfa_amap_defult_icon_button').on('click', function (event) {
        event.preventDefault();
        wfa_select_image(wfa_amap_defult_icon, 'wfa_amap_defult_icon-preview', 'wfa_amap_defult_icon');
    });
    jQuery('#upload_wfa_amap_selected_icon_button').on('click', function (event) {
        event.preventDefault();
        wfa_select_image(wfa_amap_selected_icon, 'wfa_amap_selected_icon-preview', 'wfa_amap_selected_icon');
    });
    jQuery("#set-iran-location").on('click', function (e) {
        jQuery("#wfa_amap_defult_lat").val(32.10325827993379);
        jQuery("#wfa_amap_defult_lng").val(54.219175597195);
        jQuery("#wfa_amap_defult_zoom").val(5);
    });
    
});
function wfa_select_image(set_to_post_id, preview_id, input_id) {
    var file_frame;
    var wp_media_post_id = wp.media.model.settings.post.id; // Store the old id
    // If the media frame already exists, reopen it.
    if (file_frame) {
        // Set the post ID to what we want
        file_frame.uploader.uploader.param('post_id', set_to_post_id);
        // Open frame
        file_frame.open();
        return;
    } else {
        // Set the wp.media post id so the uploader grabs the ID we want when initialised
        wp.media.model.settings.post.id = set_to_post_id;
    }

    // Create the media frame.
    file_frame = wp.media.frames.file_frame = wp.media({
        title: translate_txt.title,
        button: {
            text: translate_txt.text,
        },
        multiple: false // Set to true to allow multiple files to be selected
    });

    // When an image is selected, run a callback.
    file_frame.on('select', function () {
        // We set multiple to false so only get one image from the uploader
        attachment = file_frame.state().get('selection').first().toJSON();

        // Do something with attachment.id and/or attachment.url here
        jQuery('#' + preview_id).attr('src', attachment.url).css('width', 'auto');
        jQuery('#' + input_id).val(attachment.id);

        // Restore the main post ID
        wp.media.model.settings.post.id = wp_media_post_id;
    });

    // Finally, open the modal
    file_frame.open();
    jQuery('a.add_media').on('click', function () {
        wp.media.model.settings.post.id = wp_media_post_id;
    });
}
