function getWidth() {
    return Math.max(document.body.scrollWidth, document.documentElement.scrollWidth, document.body.offsetWidth, document.documentElement.offsetWidth, document.documentElement.clientWidth)
}
var require_filds = [
    'ostan',
    'shahr',
    'phone',
    'name',
    'height',
    'width'
];

jQuery(document).ready(function () {
    reset_agent_data();
    jQuery(".wfa-popup-back").css("width", getWidth() - 160);
    jQuery(".wfa-popup-back").css("height", screen.availHeight - 100);
    jQuery("#add-agents").click(function () {
        jQuery(".wfa-popup-back").removeClass('deactive');
    });
    jQuery(".wfa-popup-back .close").click(function () {
        jQuery(".wfa-popup-back").addClass('deactive');
    });
    jQuery(".notification .close").click(function () {
        jQuery(".notification").removeClass('active');
    });
    jQuery("#add-agents-btn").click(function () {
        add_agent(jQuery('#add-agents-form').serializeArray());
    })
    jQuery("#update_agent_list_btn").click(function () {
        jQuery("#update-loading-gif").show();
        jQuery.ajax({
            type: "POST",
            url: wp_ajax_url,
            dataType: "json",
            data: {
                action: "update_agents_json_original",
                agents: all_agents_data
            },
            cache: false,
            success: function (data) {
                jQuery("#update-loading-gif").hide();
                if (data) {
                    active_notification('success', update_text[0]);
                } else {
                    active_notification('danger', update_text[1]);
                }
            },
            error: function (e) {
                console.log(e); // error
            }
        });
    });
    jQuery("#agent_0").change(function (e) { });
    jQuery("#delete-agents").click(function () {
        delete_agent();
    });
});
function change_all_agent_checkbox(status) {
    var agent_checkboxs = jQuery(".agent_check_box");
    for (i = 0; i < agent_checkboxs.length; i++) {
        agent_checkboxs[i].checked = status;
    }
}

function delete_agent() {
    var agent_checkboxs = jQuery(".agent_check_box");
    for (i = 0; i < agent_checkboxs.length; i++) {
        if (agent_checkboxs[i].checked) {
            all_agents_data.splice(agent_checkboxs[i].value, 1);
        }
    }
    active_notification('warning', update_text[2]);
    reset_agent_data();
}
function data_validation(data) {
    var status = false;
    if (typeof data.height == 'undefined' || typeof data.width == 'undefined')
        return status;
    var h = data.height.toString().split(".");
    var w = data.width.toString().split(".");
    if (h.length == 2)
        if (typeof parseInt(h[0]) == 'number' && typeof parseInt(h[1]) == 'number')
            status = true;

    if (w.length == 2 && status)
        if (typeof parseInt(w[0]) == 'number' && typeof parseInt(w[1]) == 'number')
            status = true;
    return status;
}
function active_notification(status, text) {
    var notification = jQuery(".notification");
    notification.attr('class', "notification active " + status);
    jQuery(".notification #err-text").html(text);
}