<?php


class wfa_agents_map
{
    private static $instance = null;
    private $min_php = '5.6.0';

    private function __construct()
    {
        $this->init();
        register_activation_hook(WFA_AGENTS_MAP_PLUGIN_FILE, array($this, 'activate'));
        register_deactivation_hook(WFA_AGENTS_MAP_PLUGIN_FILE, array($this, 'deactivate'));
    }
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }
    function init()
    {
        add_action('plugins_loaded', array($this, 'load_plugin'));
        add_action('admin_init', [$this, 'install']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_scripts']);
        add_shortcode('wfa_agents_map', [$this, 'plugin_shortcode']);
    }
    function plugin_shortcode()
    {
        $agents = $this->get_agents_json();
        if (empty($agents))
            return esc_html__('No agent are defined. Please define the first agent from dashboard>settings>agents map', 'wfa-agents-map');
        $c = '';
        $val = array(
            'wfa_amap_defult_icon' => get_option('wfa_amap_defult_icon'),
            'wfa_amap_selected_icon' => get_option('wfa_amap_selected_icon'),
            'wfa_amap_defult_lat' => get_option('wfa_amap_defult_lat'),
            'wfa_amap_defult_lng' => get_option('wfa_amap_defult_lng'),
            'wfa_amap_defult_zoom' => get_option('wfa_amap_defult_zoom'),
            'wfa_amap_map_description' => get_option('wfa_amap_map_description'),
            'wfa_amap_primary_color' => get_option('wfa_amap_primary_color'),
            'wfa_amap_second_color' => get_option('wfa_amap_second_color'),
            'wfa_amap_third_color' => get_option('wfa_amap_third_color')
        );
        $translate_txt = array(
            'map_prefix' => $val['wfa_amap_map_description'],
            'email' => esc_html__('email', 'wfa-agents-map'),
            'instagram' => esc_html__('instagram', 'wfa-agents-map'),
            'website' => esc_html__('website', 'wfa-agents-map'),
            'phone' => esc_html__('phone', 'wfa-agents-map'),
            'mobile' => esc_html__('mobile', 'wfa-agents-map'),
            'agent_type' => esc_html__('Agent type', 'wfa-agents-map'),
            'ceo' => esc_html__('ceo', 'wfa-agents-map'),
            'address' => esc_html__('address', 'wfa-agents-map'),
            'show' => esc_html__('show', 'wfa-agents-map'),
            'all' => esc_html__('all', 'wfa-agents-map'),
            'province' => esc_html__('province', 'wfa-agents-map'),
            'work_time' => esc_html__('work time', 'wfa-agents-map'),
            'navigation_on_neshan' => esc_html__('Navigation on neshan', 'wfa-agents-map'),
            'navigation_on_google_maps' => esc_html__('Navigation on google maps', 'wfa-agents-map'),
            'searching_for_the_province' => esc_html__('Searching for the province', 'wfa-agents-map'),
        );
        $translate_txt = json_encode($translate_txt);
        //styles
        $val['wfa_amap_primary_color'] = empty($val['wfa_amap_primary_color']) ? '#fc0' : $val['wfa_amap_primary_color'];
        $val['wfa_amap_second_color'] = empty($val['wfa_amap_second_color']) ? '#706f6f' : $val['wfa_amap_second_color'];
        $val['wfa_amap_third_color'] = empty($val['wfa_amap_third_color']) ? '#c6c6c6' : $val['wfa_amap_third_color'];
        $c .= '<style>:root {';
        $c .= '--wfa-map-agent-primary-color: ' . $val['wfa_amap_primary_color'] . ';';
        $c .= '--wfa-map-agent-second-color: ' . $val['wfa_amap_second_color'] . ';';
        $c .= '--wfa-map-agent-third-color: ' . $val['wfa_amap_third_color'] . ';';
        $c .= '}</style>';
        $c .= '<link rel="stylesheet" href="' . WFA_AGENTS_MAP_PATH . 'assets/leaflet/leaflet.css" />';
        $c .= '<link rel="stylesheet" href="' . WFA_AGENTS_MAP_PATH . 'assets/css/wfa-agent-map-style.css" />';
        // javascripts
        $val['wfa_amap_defult_icon'] = empty($val['wfa_amap_defult_icon']) || $val['wfa_amap_defult_icon'] == 0 ? WFA_AGENTS_MAP_PATH . 'assets/images/marker-icon.png' : wp_get_attachment_url($val['wfa_amap_defult_icon']);
        $val['wfa_amap_selected_icon'] = empty($val['wfa_amap_selected_icon']) || $val['wfa_amap_selected_icon'] == 0 ? $val['wfa_amap_defult_icon'] : wp_get_attachment_url($val['wfa_amap_selected_icon']);
        $val['wfa_amap_defult_lat'] = empty($val['wfa_amap_defult_lat']) ? 32.10325827993379 : $val['wfa_amap_defult_lat'];
        $val['wfa_amap_defult_lng'] = empty($val['wfa_amap_defult_lng']) ? 54.219175597195 : $val['wfa_amap_defult_lng'];
        $val['wfa_amap_defult_zoom'] = empty($val['wfa_amap_defult_zoom']) ? 5 : $val['wfa_amap_defult_zoom'];
        $c .= '<script>';
        $c .= 'var agents =' . $agents . ';';
        $c .= 'var icon_url = {defult: "' . $val['wfa_amap_defult_icon'] . '",selected: "' . $val['wfa_amap_selected_icon'] . '"};';
        $c .= 'var defult_location = {"lat": ' . $val['wfa_amap_defult_lat'] . ',"lng": ' . $val['wfa_amap_defult_lng'] . ',"zoom": ' . $val['wfa_amap_defult_zoom'] . '};';
        $c .= 'var t_txt=' . $translate_txt . ';';
        $c .= '</script>';
        $c .= '<script src="' . WFA_AGENTS_MAP_PATH . 'assets/leaflet/leaflet.js"></script>';
        $c .= '<script src="' . WFA_AGENTS_MAP_PATH . 'assets/js/wfa-agent-map.js"></script>';
        // html
        $c .= '<div id="wfa-agents-box">';
        $c .= '<div id="agents-list-box" style="height: fit-content;">';
        $c .= '<div id="search-box">';
        $c .= '<input type="text" id="search-provinces" placeholder="">';
        $c .= '</div>';
        $c .= '<div id="provinces-boxs"></div>';
        $c .= '</div>';
        $c .= '<div id="agents-map-box">';
        $c .= '<div style="position: absolute;">';
        $c .= '<div id="agent-info-box"></div>';
        $c .= '</div>';
        $c .= '<div id="agents-map"></div>';
        $c .= '</div>';
        $c .= '</div>';
        return $c;
    }
    public function enqueue_scripts()
    {
        wp_enqueue_script('wfa-agents-map-js', plugins_url('assets/js/admin-scripts.js', __FILE__), array('wp-color-picker'), false, true);
        wp_localize_script('wfa-agents-map-js', 'params', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'ajax_nonce' => wp_create_nonce('bazara_security')

        ));
    }
    function load_plugin()
    {
        load_plugin_textdomain('wfa-agents-map', false, basename(dirname(__FILE__)) . '/languages/');
        add_action('admin_menu', [$this, 'plugin_menu']);
        if (is_admin()) {
            add_action("wp_ajax_nopriv_update_agents_json_original", [$this, 'update_agents_json_original']);
            add_action("wp_ajax_update_agents_json_original",  [$this, 'update_agents_json_original']);
        }
    }
    public static function update_agents_json_original()
    {
        if (isset($_POST['agents'])) {
            $json_file = fopen(plugin_dir_path(__FILE__) . 'assets/jsons/original.json', "w+");
            fwrite($json_file, json_encode($_POST['agents']));
            fclose($json_file);
            wp_send_json(true);
        } else
            wp_send_json(false);
        wp_die();
    }

    public function plugin_menu()
    {

        add_submenu_page(
            'options-general.php',
            esc_html__('Agents Map Setting', 'wfa-agents-map'),
            esc_html__('Agents Map', 'wfa-agents-map'),
            'manage_options',
            'wfa-agents-map',
            [$this, 'plugin_settings_page']
        );
        add_action('admin_init', [$this, 'plugin_settings_init']);
    }

    public function plugin_settings_page()
    {
        if (!current_user_can('manage_options')) {
            return;
        }
        $default_tab = null;
        $tab = isset($_GET['tab']) ? $_GET['tab'] : $default_tab;
        $tab = $tab == 'settings' ? 'settings' : $default_tab;
        ?>
        <div class="wrap">
            <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
            <?php settings_errors(); ?>
            <p><?php _e('for show agent map, use shortcode: ', 'wfa-agents-map'); ?><strong class="to-copy">[wfa_agents_map]</strong></p>
            <nav class="nav-tab-wrapper">
                <a href="?page=wfa-agents-map" class="nav-tab <?php if ($tab === null) : ?>nav-tab-active<?php endif; ?>"><?php _e('Agents List', 'wfa-agents-map'); ?></a>
                <a href="?page=wfa-agents-map&tab=settings" class="nav-tab <?php if ($tab === 'settings') : ?>nav-tab-active<?php endif; ?>"><?php _e('Settings', 'wfa-agents-map'); ?></a>
            </nav>

            <div class="tab-content">
                <?php
                $this->plugin_page_tabs($tab);
                ?>
            </div>
        </div>
        <?php
    }
    public function plugin_settings_init()
    {
        add_settings_section(
            'wfa-agents-map-settings-section',
            esc_html__('Agents Map Setting', 'wfa-agents-map'),
            '',
            'wfa-agents-map'
        );
        register_setting('wfa-agents-map', 'wfa_amap_defult_icon');
        register_setting('wfa-agents-map', 'wfa_amap_selected_icon');
        register_setting('wfa-agents-map', 'wfa_amap_defult_lat');
        register_setting('wfa-agents-map', 'wfa_amap_defult_lng');
        register_setting('wfa-agents-map', 'wfa_amap_defult_zoom');
        register_setting('wfa-agents-map', 'wfa_amap_map_description');
        register_setting('wfa-agents-map', 'wfa_amap_primary_color');
        register_setting('wfa-agents-map', 'wfa_amap_second_color');
        register_setting('wfa-agents-map', 'wfa_amap_third_color');
    }
    private function plugin_page_tabs($tab = null)
    {
        switch ($tab) {
            case 'settings':
                wp_enqueue_media();
                wp_enqueue_style('wp-color-picker');
                wp_enqueue_script('wp-color-picker');
                $val = array(
                    'wfa_amap_defult_icon' => get_option('wfa_amap_defult_icon'),
                    'wfa_amap_selected_icon' => get_option('wfa_amap_selected_icon'),
                    'wfa_amap_defult_lat' => get_option('wfa_amap_defult_lat'),
                    'wfa_amap_defult_lng' => get_option('wfa_amap_defult_lng'),
                    'wfa_amap_defult_zoom' => get_option('wfa_amap_defult_zoom'),
                    'wfa_amap_map_description' => get_option('wfa_amap_map_description'),
                    'wfa_amap_primary_color' => get_option('wfa_amap_primary_color'),
                    'wfa_amap_second_color' => get_option('wfa_amap_second_color'),
                    'wfa_amap_third_color' => get_option('wfa_amap_third_color')
                );

        ?>
                <script src="<?php echo WFA_AGENTS_MAP_PATH; ?>assets/js/setting-page.js"></script>
                <link rel="stylesheet" href="<?php echo WFA_AGENTS_MAP_PATH; ?>assets/css/setting-page-style.css" />
                <script type='text/javascript'>
                    var translate_txt = {
                        title: "<?php _e('Select a image to upload', 'wfa-agents-map') ?>",
                        text: '<?php _e('Use this image', 'wfa-agents-map') ?>'
                    };
                    var wfa_amap_defult_icon = <?php echo (empty($val['wfa_amap_defult_icon'])) ? 0 : $val['wfa_amap_defult_icon']; ?>;
                    var wfa_amap_selected_icon = <?php echo (empty($val['wfa_amap_selected_icon'])) ? 0 : $val['wfa_amap_selected_icon']; ?>;
                </script>
                <form method="POST" action="options.php">
                    <div id="setting-section">
                        <div class="row">
                            <h3 class="row-title"><?php _e('Map Icons', 'wfa-agents-map'); ?></h3>
                            <div class="column">
                                <div>
                                    <p><?php _e('1-Defalt Icon in Map', 'wfa-agents-map'); ?></p>
                                </div>
                                <div><input id="upload_wfa_amap_defult_icon_button" type="button" class="button" value="<?php _e('Upload image', 'wfa-agents-map'); ?>" /></div>
                                <input type='hidden' name='wfa_amap_defult_icon' id='wfa_amap_defult_icon' value='<?php echo $val['wfa_amap_defult_icon']; ?>'>
                                <div><img id='wfa_amap_defult_icon-preview' src='<?php echo wp_get_attachment_url($val['wfa_amap_defult_icon']); ?>' width='30' style='width: 30px;'></div>
                            </div>
                            <div class="column">
                                <div>
                                    <p><?php _e('1-Selected Icon in Map', 'wfa-agents-map'); ?></p>
                                </div>
                                <div><input id="upload_wfa_amap_selected_icon_button" type="button" class="button" value="<?php _e('Upload image', 'wfa-agents-map'); ?>" /></div>
                                <input type='hidden' name='wfa_amap_selected_icon' id='wfa_amap_selected_icon' value='<?php echo $val['wfa_amap_selected_icon']; ?>'>
                                <div><img id='wfa_amap_selected_icon-preview' src='<?php echo wp_get_attachment_url($val['wfa_amap_selected_icon']); ?>' width='30' style='width: 30px;'></div>
                            </div>
                        </div>
                        <div class="row">
                            <h3 class="row-title"><?php _e('Defalt Map Location', 'wfa-agents-map'); ?></h3>
                            <div class="column">
                                <label for="wfa_amap_defult_lat"><?php _e('lat', 'wfa-agents-map'); ?></label><br>
                                <input type="text" name="wfa_amap_defult_lat" id="wfa_amap_defult_lat" value="<?php echo $val['wfa_amap_defult_lat']; ?>">
                            </div>
                            <div class="column">
                                <label for="wfa_amap_defult_lng"><?php _e('lng', 'wfa-agents-map'); ?></label><br>
                                <input type="text" name="wfa_amap_defult_lng" id="wfa_amap_defult_lng" value="<?php echo $val['wfa_amap_defult_lng']; ?>">
                            </div>
                            <div class="column">
                                <label for="wfa_amap_defult_zoom"><?php _e('zoom', 'wfa-agents-map'); ?></label><br>
                                <input type="number" name="wfa_amap_defult_zoom" id="wfa_amap_defult_zoom" value="<?php echo $val['wfa_amap_defult_zoom']; ?>" min="1" max="99">
                            </div>
                            <?php if (get_bloginfo('language', 'display') == 'fa-IR') { ?>
                                <div class="column">
                                    <span class="button" id="set-iran-location">تنظیم موقعیت ایران</span>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="row">
                            <h3 class="row-title"><?php _e('Defalt Map Location', 'wfa-agents-map'); ?></h3>
                            <div class="column">
                                <label for="wfa_amap_primary_color"><?php _e('Primary Color', 'wfa-agents-map'); ?></label><br>
                                <input type="text" class="wfa-color-picker" name="wfa_amap_primary_color" id="wfa_amap_primary_color" value="<?php echo $val['wfa_amap_primary_color']; ?>" min="1" max="99">
                            </div>
                            <div class="column">
                                <label for="wfa_amap_second_color"><?php _e('Second Color', 'wfa-agents-map'); ?></label><br>
                                <input type="text" class="wfa-color-picker" name="wfa_amap_second_color" id="wfa_amap_second_color" value="<?php echo $val['wfa_amap_second_color']; ?>" min="1" max="99">
                            </div>
                            <div class="column">
                                <label for="wfa_amap_third_color"><?php _e('Third Color', 'wfa-agents-map'); ?></label><br>
                                <div><input type="text" class="wfa-color-picker" name="wfa_amap_third_color" id="wfa_amap_third_color" value="<?php echo $val['wfa_amap_third_color']; ?>" min="1" max="99"></div>
                            </div>
                        </div>
                        <div class="row">
                            <h3 class="row-title"><?php _e('Description of the corner of the map', 'wfa-agents-map'); ?></h3>
                            <div class="column">
                                <label for="wfa_amap_map_description"><?php _e('Description', 'wfa-agents-map'); ?></label><br>
                                <input type="text" name="wfa_amap_map_description" id="wfa_amap_map_description" value="<?php echo $val['wfa_amap_map_description']; ?>" min="1" max="99">
                            </div>
                        </div>
                    </div>
                    <?php settings_fields('wfa-agents-map'); ?>
                    <?php submit_button(); ?>
                </form>
            <?php
                break;
            default:
                $agents = $this->get_agents_json();
                $ajax_url = esc_url(admin_url('admin-ajax.php'));
            ?>
                <script src="<?php echo WFA_AGENTS_MAP_PATH; ?>assets/js/agent-list-page.js"></script>
                <link rel="stylesheet" href="<?php echo WFA_AGENTS_MAP_PATH; ?>assets/css/list-page-style.css" />
                <script>
                    var all_agents_data = <?php echo empty($agents) ? '[]' : $agents; ?>;
                    var wp_ajax_url = "<?php echo $ajax_url; ?>";
                    var update_text = [
                        '<?php _e('Agent data has been successfully updated', 'wfa-agents-map'); ?>',
                        '<?php _e('an error occurred while update the agents data', 'wfa-agents-map'); ?>',
                        '<?php _e('Agent data has been edited but not updated.', 'wfa-agents-map'); ?>'
                    ];

                    function add_agent(agent) {
                        correct_info = true;
                        temp_agent = {};
                        for (i = 0; i < agent.length; i++) {
                            if (require_filds.includes(agent[i].name)) {
                                if (agent[i].value == "") {
                                    correct_info = false;
                                    jQuery("#add-agents-form #notification").addClass('err');
                                    jQuery("#add-agents-form #notification").html("<?php _e('Fields with * are required', 'wfa-agents-map'); ?>");
                                    break;
                                }
                            }
                            if (agent[i].value != "") temp_agent[agent[i].name] = agent[i].value;
                        }
                        if (correct_info) {
                            temp_agent['agent_id'] = all_agents_data.length + 1;
                            all_agents_data.push(temp_agent);
                            jQuery(".wfa-popup-back").addClass('deactive');
                            jQuery("#add-agents-form")[0].reset();
                            active_notification('warning', update_text[2]);
                            reset_agent_data();
                        }
                    }



                    function reset_agent_data() {
                        if (all_agents_data.length > 0) {

                            var content = '<div class="row"><div class="column"><input type="checkbox" id="agent_0" name="agent_0" value="0"></div><div class="column"><?php _e('Name', 'wfa-agents-map'); ?></div><div class="column"><?php _e('Status', 'wfa-agents-map'); ?></div><div class="column"><?php _e('Province', 'wfa-agents-map'); ?></div><div class="column"><?php _e('City', 'wfa-agents-map'); ?></div><div class="column"><?php _e('Long', 'wfa-agents-map'); ?></div><div class="column"><?php _e('Lat', 'wfa-agents-map'); ?></div></div>';
                            for (i = all_agents_data.length - 1; i >= 0; i--) {
                                agent = all_agents_data[i];
                                var status = data_validation(agent);
                                var sclass = status ? 'enable' : 'disable';
                                status = status ? '<?php _e('Enable', 'wfa-agents-map'); ?>' : '<?php _e('Disable', 'wfa-agents-map'); ?>';

                                content += '<div class="row">';
                                content += '<div class="column"><input class="agent_check_box" type="checkbox" id="agent_' + agent.agent_id + '" name="agent_' + agent.agent_id + '" value="' + i + '">&nbsp;<label for="agent_' + agent.agent_id + '">' + agent.agent_id + '</label></div>';
                                content += '<div class="column">' + agent.name + '</div>';
                                content += '<div class="column ' + sclass + '">' + status + '</div>';
                                content += '<div class="column">' + agent.ostan + '</div>';
                                content += '<div class="column">' + agent.shahr + '</div>';
                                content += '<div class="column">' + agent.height + '</div>';
                                content += '<div class="column">' + agent.width + '</div>';
                                content += '</div>';
                            }
                            jQuery("#agent-data-table").html(content);
                            jQuery("#agent_0").click(function(e) {
                                change_all_agent_checkbox(e.currentTarget.checked);
                            });
                        } else {
                            jQuery("#agent-data-table").html('<?php _e('No agents have been added.', 'wfa-agents-map'); ?>');
                        }
                    }
                </script>
                <div class="wfa-popup-back deactive">
                    <form id="add-agents-form" onsubmit="return false;">
                        <span class="close">x</span>
                        <div style="width: 100%;">
                            <strong><?php _e('Add Agents', 'wfa-agents-map'); ?></strong>
                            <p id="notification"><?php _e('Enter agent information.', 'wfa-agents-map'); ?></p>
                        </div>
                        <div><input name="ostan" id="ostan" type="text" placeholder="<?php _e('Province', 'wfa-agents-map'); ?>*" require></div>
                        <div><input name="shahr" id="shahr" type="text" placeholder="<?php _e('City', 'wfa-agents-map'); ?>*" require></div>
                        <div><input name="title" id="title" type="text" placeholder="<?php _e('Title', 'wfa-agents-map'); ?>"></div>
                        <div><input name="name" id="name" type="text" placeholder="<?php _e('Name', 'wfa-agents-map'); ?>*" require></div>
                        <div><input name="phone" id="phone" type="text" placeholder="<?php _e('Phone', 'wfa-agents-map'); ?>*" require></div>
                        <div><input name="mobile" id="mobile" type="text" placeholder="<?php _e('Mobile', 'wfa-agents-map'); ?>"></div>
                        <div><input name="address" id="address" type="text" placeholder="<?php _e('Address', 'wfa-agents-map'); ?>"></div>
                        <div><input name="height" id="height" type="text" placeholder="<?php _e('long', 'wfa-agents-map'); ?>*" require></div>
                        <div><input name="width" id="width" type="text" placeholder="<?php _e('lat', 'wfa-agents-map'); ?>*" require></div>
                        <div><input name="saat" id="saat" type="text" placeholder="<?php _e('Work Time', 'wfa-agents-map'); ?>"></div>
                        <div><input name="site" id="site" type="text" placeholder="<?php _e('Web Site', 'wfa-agents-map'); ?>"></div>
                        <div><input name="instagram" id="instagram" type="text" placeholder="<?php _e('Instagram', 'wfa-agents-map'); ?>"></div>
                        <div><input name="email" id="email" type="text" placeholder="<?php _e('Email', 'wfa-agents-map'); ?>"></div>
                        <div><input name="agent_type" id="agent_type" type="text" placeholder="<?php _e('Agent Type', 'wfa-agents-map'); ?>"></div>
                        <div style="width: 100%;text-align: left;">
                            <input type="submit" disabled style="display: none;">
                            <button id="add-agents-btn"><?php _e('Add', 'wfa-agents-map'); ?></button>
                        </div>
                    </form>
                </div>
                <div class="notification">
                    <div style="position: relative;"><span class="close">x</span></div>
                    <p id="err-text"></p>
                </div>
                <div style="width: 100%;">
                    <p><?php _e('You must update after adding or deleting agents and In the final map, only Enable agents are displayed', 'wfa-agents-map'); ?></p>
                </div>
                <div class="button-boxs">
                    <div>
                        <button id="add-agents"><?php _e('Add', 'wfa-agents-map'); ?></button>
                        <button id="delete-agents"><?php _e('Group delete', 'wfa-agents-map'); ?></button>
                    </div>
                    <div>
                        <img id="update-loading-gif" src="<?php echo WFA_AGENTS_MAP_PATH; ?>assets/images/loading.gif" style="width: 15px;margin-bottom: -4px;display:none;">
                        <button id="update_agent_list_btn"><?php _e('Update', 'wfa-agents-map'); ?></button>
                    </div>
                </div>
                <div class="table" id="agent-data-table">
                    <label for=""></label>
                </div>
        <?php
                break;
        }
    }

    public function install()
    {
    }
    public function is_supported_php()
    {
        return (version_compare(PHP_VERSION, $this->min_php, '<=')) ? false : true;
    }
    public function activate()
    {
        if (!$this->is_supported_php()) {
            wc_print_notice(sprintf(__('The Minimum PHP Version Requirement for <b>Order Notification</b> is %s. You are Running PHP %s', 'dokan'), $this->min_php, phpversion(), 'error'));
            exit;
        }
    }
    function deactivate()
    {
        if (!$this->is_supported_php()) {
            wc_print_notice(sprintf(__('The Minimum PHP Version Requirement for <b>Order Notification</b> is %s. You are Running PHP %s', 'dokan'), $this->min_php, phpversion(), 'error'));
            exit;
        }
    }
    function get_agents_json()
    {
        return $this->file_get_contents_curl(WFA_AGENTS_MAP_PATH . 'assets/jsons/original.json');
    }
    private function file_get_contents_curl($url)
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);

        $data = curl_exec($ch);
        curl_close($ch);

        return $data;
    }
}
wfa_agents_map::instance();
