/**
 * author: Reza Rad
 * Date: 28/10/2022
  */
// sort agent list based on ostan
agents.sort(function (e, a) {
    return e.ostan < a.ostan ? -1 : e.ostan > a.ostan ? 1 : 0
});

// set icons
const LeafIcon = L.Icon.extend({ options: { iconSize: [28.42, 45] } });
const LeafIcon2 = L.Icon.extend({ options: { iconSize: [57, 87] } });
const marker_icon = new LeafIcon({ iconUrl: icon_url.defult });
const marker_selected_icon = new LeafIcon2({ iconUrl: icon_url.selected });

var map;
var markers = []; // variable for save all markers
var last_marker = 0; // last selected marker
var agent_for_remove=[];
var provinces = []; //variable for save provinces with latlng from agents list
for (i = 0; i < agents.length; i++) { // set list of provinces
 console.log(agents[i].ostan);
  
  agents[i].ostan=agents[i].ostan.trim();
  console.log(agents[i].ostan);
    if (typeof agents[i].height !== 'undefined' && typeof agents[i].width !== 'undefined') {
        if (provinces.find(element => element.state == agents[i].ostan)) {
            provinces.find(element => element.state == agents[i].ostan).list.push(agents[i])
        } else {
            provinces.push({
                'state_id': (i + 1),
                'state': agents[i].ostan,
                'list': [agents[i]]
            });
        }
    } else {
      agent_for_remove.push(i);
        
    }
}
for (i = 0; i < agent_for_remove.length; i++) { 
  agents.splice(agent_for_remove[i], 1);
}

// get page width
function getWidth() { return Math.max(document.body.scrollWidth, document.documentElement.scrollWidth, document.body.offsetWidth, document.documentElement.offsetWidth, document.documentElement.clientWidth) }
// get page height
function getHeight() { return Math.max(document.body.scrollHeight, document.documentElement.scrollHeight, document.body.offsetHeight, document.documentElement.offsetHeight, document.documentElement.clientHeight) }

// create map
function create_map() {
    // set map width and height
    jQuery("#agents-map").css("width", jQuery("#agents-list-box").css("width"));
    if (getWidth() < 1024)
        jQuery("#agents-map").css("height", jQuery("#agents-map").css("width"));
    else
        jQuery("#agents-map").css("height", jQuery("#agents-list-box").css("height"));

    // create map layer
    map = L.map('agents-map').setView([defult_location.lat, defult_location.lng], defult_location.zoom);
    L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
        maxZoom: 17,
        minZoom: 5,
    }).addTo(map);
    // Attribution for map
    L.control.attribution({ prefix: t_txt.map_prefix }).addTo(map);
}
// create provinces boxs and insert in target div
function create_provinces_boxs() {
    var content = '<div class="provinces-box active" id="provinces_0"><p>' + t_txt.show + '<br><strong>' + t_txt.all + '</strong></p></div>';
    for (i = 1; i <= provinces.length; i++) {
        if ((i / 6) == Math.floor(i / 6))
            content += '<div class="provinces-meta-boxs" id="provinces_meta_box_' + Math.floor(i / 6) + '">1</div>';
        content += '<div class="provinces-box" id="provinces_' + provinces[i - 1].state_id + '" data-boxid="' + i + '" data-province="' + provinces[i - 1].state + '"><p>' + t_txt.province + '<br><strong>' + provinces[i - 1].state + '</strong></p></div>';
        if (i == provinces.length)
            content += '<div class="provinces-meta-boxs" id="provinces_meta_box_' + (Math.floor(i / 6) + 1) + '">1</div>';
    }
    jQuery("#provinces-boxs").html(content);

    jQuery(".provinces-box").click(function (e) {

        set_province_box(e.currentTarget, -2);
    });
}

// add all marker to map from list
function add_all_marker(list) {
    markers = [];
    for (i = 0; i < list.length; i++) {
        if (typeof list[i].title !== 'undefined' && typeof agents[i].height !== 'undefined' && typeof agents[i].width !== 'undefined') {
            markers[i] = L.marker([list[i].width, list[i].height], { icon: marker_icon }).addTo(map);
            markers[i]._id = i;
            markers[i]._agent_id = list[i].agent_id;
            markers[i].on('click', function (e) {
                e.target.setIcon(marker_selected_icon);
                onMapClick(e);
                e.target.setIcon(marker_selected_icon);
            });

        }
    }
}
// remove all marker in map
function remove_all_markers() {
    for (i = 0; i < markers.length; i++) {
        if (typeof markers[i] !== 'undefined')
            map.removeLayer(markers[i]);
    }
    markers = [];
}
// rest map to defult value
function rest_map_to_defult() {
    remove_all_markers();
    add_all_marker(agents);
    map.setView([defult_location.lat, defult_location.lng], defult_location.zoom);
    markers[last_marker].setIcon(marker_icon);
    jQuery(".close").parent().html('');
    jQuery(".provinces-box.active").removeClass("active");
    jQuery(".provinces-box.active").removeClass("active");
    jQuery(".provinces-meta-boxs.active").removeClass("active");
    jQuery("#provinces_0").addClass("active");

    jQuery(".provinces-box.selected").removeClass("selected");
    jQuery("#search-provinces").val('');
}
// set province box from 
function set_province_box(p, agent_id = -1) {
    jQuery(".provinces-box.selected").removeClass("selected");
    jQuery(".provinces-box.active").removeClass("active");
    jQuery(".provinces-meta-boxs.active").removeClass("active");
    var boxid, latlng;
    if (agent_id == -2) {
        boxid = p.getAttribute('data-boxid');
        latlng = { lat: p.getAttribute('data-lat'), lng: p.getAttribute('data-lng') };
        jQuery("#" + p.id).addClass("active");
    } else {
        boxid = p[0].dataset.boxid;
        latlng = { lat: p[0].dataset.lat, lng: p[0].dataset.lng };
        jQuery("#" + p[0].id).addClass("active");
    }

    if (p.id == "provinces_0") {
        rest_map_to_defult();
    } else {
        provinces_meta_box_id = "#provinces_meta_box_" + (Math.floor(boxid / 6) + 1);
        jQuery(provinces_meta_box_id).addClass("active");
        agent_list = provinces[boxid - 1].list;

        map.fitBounds(create_agent_list_item(agent_list, provinces_meta_box_id, agent_id));
    }
}

function create_agent_list_item(agents_list, section_id, agent_id) {
    var latlngs = [];
    var c = '';
    for (i = 0; i < agents_list.length; i++) {
        address = (typeof agents_list[i].address === 'undefined') ? agents_list[i].ostan + " (" + agents_list[i].shahr + ")" : agents_list[i].address;
        title = (typeof agents_list[i].title === 'undefined') ? agents_list[i].name : agents_list[i].title;
        status = (agent_id == agents_list[i].agent_id) ? 'active' : '';
        c += '<div class="row ' + status + '" id="agent_row_box_' + agents_list[i].agent_id + '" data-agentid="' + agents_list[i].agent_id + '">';
        c += '<div class="color"></div>';
        c += '<div style="width: 30%;">' + title + '</div>';
        c += '<div style="width: 45%;"><span>' + t_txt.address + ': </span>' + address + '</div>';
        c += '<div style="width: 25%;"><span>' + t_txt.phone + ': </span><p>' + agents_list[i].phone + '</p></div>';
        c += '</div>';
        latlngs.push([agents_list[i].width, agents_list[i].height]);
    }
    jQuery(section_id).html(c);
    remove_all_markers();
    add_all_marker(agents_list);
    // From This
    jQuery(".provinces-meta-boxs .row").click(function (e) {
        jQuery(".provinces-meta-boxs .row.active").removeClass("active");
        var selected_marker = jQuery("#" + e.currentTarget.id);
        selected_marker.addClass("active");
        var s;
        console.log(markers);
        console.log(selected_marker[0].dataset.agentid);
        var marker = markers.find(element => element._agent_id == selected_marker[0].dataset.agentid);
        find(function (element, index) {
            s = index;
            return element._agent_id == selected_marker[0].dataset.agentid;
        });
        markers[marker._id].setIcon(marker_selected_icon);
        map.setView([marker._latlng.lat, marker._latlng.lng], 13);
        markers[last_marker].setIcon(marker_icon);

        last_marker = marker._id;
        set_agent_data_from_marker(marker._agent_id, false);
    });
    return latlngs;
}

function set_agent_data_from_marker(id, province = true) {
    agent = agents.find(element => element.agent_id == id);
    address = (typeof agent.address === 'undefined') ? agent.ostan + "( " + agent.shahr + " )" : agent.address;
    c = '';
    c += '<div class="info-row"><strong>' + agent.title + '</strong></div>';
    if (typeof agent.name !== 'undefined') c += '<div class="info-row">' + t_txt.ceo + ': <strong>' + agent.name + '</strong></div>';
    if (typeof agent.agent_type !== 'undefined') c += '<div class="info-row">' + t_txt.agent_type + ': <strong>' + agent.agent_type + '</strong></div>';
    if (typeof agent.phone !== 'undefined') c += '<div class="info-row" style="display: flex;">' + t_txt.phone + ': <strong style="display: revert;margin: 0 5px 0 0;">' + agent.phone + '</strong></div>';
    if (typeof agent.mobile !== 'undefined') c += '<div class="info-row">' + t_txt.mobile + ': <strong>' + agent.mobile + '</strong></div>';
    if (typeof agent.site !== 'undefined') c += '<div class="info-row">' + t_txt.website + ': <a href="http://' + agent.site + '" target="_blank"><strong>' + agent.site + '</strong></a></div>';
    if (typeof agent.instagram !== 'undefined') c += '<div class="info-row">' + t_txt.instagram + ': <a href="https://www.instagram.com/' + agent.instagram + '" target="_blank"><strong>' + agent.instagram + '@</strong></a></div>';
    if (typeof agent.email !== 'undefined') c += '<div class="info-row">' + t_txt.email + ': <strong>' + agent.email + '</strong></div>';
    if (typeof agent.saat !== 'undefined') c += '<div class="info-row">' + t_txt.work_time + ': <strong>' + agent.saat + '</strong></div>';
    if (typeof address !== 'undefined') c += '<div class="info-row">' + t_txt.address + ': <strong>' + address + '</strong></div>';
    c += '<div class="info-row text-color-primary"><a href="https://neshan.org/maps/routing/car/destination/' + agent.width + ',' + agent.height + '" target="_blank">' + t_txt.navigation_on_neshan + '</a></div>';
    c += '<div class="info-row text-color-primary"><a href="https://www.google.com/maps/place/' + agent.width + ',' + agent.height + '" target="_blank">' + t_txt.navigation_on_google_maps + '</a></div>';
    c += '<span class="close">x</span>';
    jQuery("#agent-info-box").html(c);
    jQuery(".close").click(function () {
        rest_map_to_defult();
    });

    if (province) {
        state = provinces.find(element => element.state == agent.ostan);

        set_province_box(jQuery("#provinces_" + state.state_id), agent.agent_id);
    }
}


function onMapClick(e) {

    set_agent_data_from_marker(e.target._agent_id);
    //markers[last_marker].setIcon(marker_icon);

    map.setView([e.latlng.lat, e.latlng.lng], 13);
    last_marker = e.target._id;
}

function search_provinces(text) {
    jQuery(".provinces-box.active").removeClass("active");
    jQuery("#provinces_0").addClass("active");
    var boxs = jQuery(".provinces-box");
    var temp_text = "";
    for (i = 1; i < boxs.length; i++) {
        temp_text = boxs[i].getAttribute("data-province");
        if (parseInt(temp_text.search(text)) >= 0) {
            jQuery("#" + boxs[i].id).addClass("selected");
        }
    }

}

function set_defult_elements() {
    var defult_element;
    defult_element += '<div id="wfa-agents-box">';
    defult_element += ' <div id="agents-list-box" style="height: fit-content;">';
    defult_element += '  <div id="search-box"><input type="text" id="search-provinces" placeholder="' + t_txt.searching_for_the_province + '"></div>';
    defult_element += '  <div id="provinces-boxs"></div>';
    defult_element += ' </div>';
    defult_element += ' <div id="agents-map-box">';
    defult_element += ' <div style="position: absolute;">div id="agent-info-box"></div></div>';
    defult_element += ' <div id="agents-map"></div>';
    defult_element += '</div></div>';
    return defult_element;
}

jQuery(document).ready(function () {
    jQuery("#search-provinces").attr("placeholder", t_txt.searching_for_the_province);
    create_provinces_boxs();
    create_map()
    add_all_marker(agents);
    jQuery("#search-provinces").keyup(function (e) {
        var value = jQuery(this).val();
        rest_map_to_defult();
        jQuery(this).val(value);
        if (value != "") {
            search_provinces(value);
        }
    });
});