<?php

/*
  Plugin Name: WooPricely - Dynamic Pricing & Discounts
  Plugin URI: https://codecanyon.net/item/woopricely-dynamic-pricing-fees-discounts/23844181?ref=zendcrew
  Description: A multi-purpose pricing and discount toolkit for your WooCommerce store.
  Version: 1.3.9
  Author: ورپرس سریع
  Author URI: wpfast.ir
  Tags: woocommerce, pricing, discounts, dynamic pricing, dynamic discounts, woocommerce dynamic pricing, woocommerce dynamic discounts, woocommerce pricing, woocommerce discounts, advanced pricing, bulk discounts, bulk pricing, ecommerce, quantity discounts, quantity pricing, user role discounts, user role pricing, whole discounts, whole pricing, membership pricing, membership discounts, cart discounts, cart fees, woocommerce discount, woocommerce cart discounts, woocommerce cart fees, woocommerce bulk pricing, woocommerce prices, woocommerce wholesale pricing, woocommerce bogo pricing, woocommerce bulk discounts, woocommerce dynamic prices, woocommerce special offers, woocommerce pricing deals, woocommerce buy one get one free, woocommerce price rules, woocommerce advanced discounts, woocommerce pricing deals, woocommerce discount rules, discount rules for woocommerceole discounts, role pricing
  Text Domain: zc-woo-pricely
  WC requires at least: 3.0
  WC tested up to: 4.4.1
 */



require_once (dirname(__FILE__) . '/framework/reon_loader.php');

if (!function_exists('zcwpr_pricely_init')) {

    function zcwpr_pricely_init() {        
        if (zcwpr_is_plugin_active('woocommerce.php')) {
            include_once('extensions/extensions.php');
        }
    }

}

zcwpr_pricely_init();

function zcwpr_is_plugin_active($plugin_filename) {
    $active_plugins = (array) get_option('active_plugins', array());

    foreach ($active_plugins as $active_plugin) {
        if (stripos($active_plugin, $plugin_filename)) {
            return true;
        }
    }


    if (!is_multisite()) {
        return false;
    }

    $active_site_plugins = get_site_option('active_sitewide_plugins');

    $active_plugins_keys = array_keys($active_site_plugins);
    foreach ($active_plugins_keys as $active_plugins_key) {
        if (stripos($active_plugins_key, $plugin_filename)) {
            return true;
        }
    }

    return false;
}
