<?php
$import_export = $page['import_export'];
$sections = array();
$last = -1;
foreach ($page['sections'] as $section) {

    if ($section['subsection'] != true) {
        $last++;
        $sections[$last] = $section;
    } else {
        $sections[$last]['subsections'][] = $section;
    }
}
if ($import_export['enable'] == true) {
    $last++;
    $sections[$last] = array(
        'id' => 'rn_import_export',
        'title' => $import_export['title'],
        'subsection' => false,
        'group' => 0,
        'fields' => array('')
    );
}
?>
<div data-active="<?php echo esc_attr($page['tab']); ?>" class="rn-option-page-tabs">
    <ul class="rn-option-page-tabs-list">
        <?php
        $data_key = 0;
        foreach ($sections as $section) {
            $data_key++;
            $menu_url = '#' . esc_attr($section['id']);
            $is_not_active_group=false;
            if(isset($page['group'])){

            $is_not_active_group = !($page['group'] == $section['group']);
            }
            if ($is_not_active_group == true) {
                $menu_url = admin_url() . $page['menu']['base_url'] . '?page=' . $page['menu']['slug'] . '&tab=' . $data_key;
            }
            ?>
            <li data-key="<?php echo esc_attr($data_key); ?>" class="rn-option-li<?php echo (isset($section['subsections']) && count($section['subsections']) > 0) ? ' haschild' : ''; ?><?php echo (count($section['fields']) == 0) ? ' empty-group' : ''; ?>">
                <a<?php echo (!$is_not_active_group) ? ' data-active-group="yes"' : ''; ?> href="<?php echo $menu_url; ?>"><?php echo esc_html($section['title']); ?></a>
                <?php
                if ((isset($section['subsections']) && count($section['subsections']) > 0) || $section['id'] == 'rn_import_export') {
                    ?>
                    <ul class="rn-option-page-tabs-sublist">
                        <?php
                        if (isset($section['subsections'])) {
                            foreach ($section['subsections'] as $subsection) {
                                $data_key++;
                                $menu_url = '#' . esc_attr($subsection['id']);
                                $is_not_active_group = !($page['group'] == $subsection['group']);
                                if ($is_not_active_group == true) {
                                    $menu_url = admin_url() . $page['menu']['base_url'] . '?page=' . $page['menu']['slug'] . '&tab=' . $data_key;
                                }
                                ?>  
                                <li data-key="<?php echo esc_attr($data_key); ?>" class="rn-option-subli"><a<?php echo (!$is_not_active_group) ? ' data-active-group="yes"' : ''; ?> href="<?php echo $menu_url;
                ; ?>"><?php echo esc_html($subsection['title']); ?></a></li>
                                    <?php
                                }
                            }
                            ?>
                    </ul><!-- .rn-option-page-tabs-sublist -->
                    <?php
                }
                ?>
            </li>
            <?php
        }
        ?>   
    </ul><!-- .rn-option-page-tabs-list -->
</div><!-- .rn-option-page-tabs -->