<div <?php echo ReonUtil::array_to_attributes(apply_filters('reon/control-parent-attributes', $attr, $g_field)); ?>>
    <table>
        <?php
        if (isset($g_field['inner_title']) || isset($g_field['inner_desc'])) {
            ?>

            <tr class="rn-ui-section rn-ui-big-section rn-ui-title-section" style="display: table-caption;">
                <td class="rn-ui-block" colspan="<?php echo esc_attr(count($clm_fields)); ?>">
                    <div class="rn-ui-head rn-center">
                        <?php if (isset($g_field['inner_title']) && $g_field['inner_title'] != '') {
                            ?>
                            <h6 class="rn-ui-head-title"><?php echo esc_attr($g_field['inner_title']); ?></h6>
                        <?php }
                        ?>
                        <?php if (isset($g_field['inner_desc']) && $g_field['inner_desc'] != '') {
                            ?>
                            <p class="rn-ui-head-desc">
                                <?php echo wp_kses_post($g_field['inner_desc']); ?>
                            </p> 
                            <?php
                        }
                        ?>                
                    </div>

                </td><!-- .rn-ui-block -->
            </tr>

        <?php } ?>
        <?php
        if (isset($g_field['inner_title']) || isset($g_field['inner_desc'])) {
            ?>
            <tr>
                <td colspan="<?php echo esc_attr(count($clm_fields)); ?>">
                    <div class="rn-columns-title-gap"></div>
                </td>
            </tr>                    
        <?php } ?>
        <tr> 
            <?php
            $args = ReonUtil::get_screen_args_from_field($g_field);

            if (count($clm_fields) > 0) {
                $total_columns = 1;
                if (isset($g_field['columns'])) {
                    $total_columns = $g_field['columns'];
                }
                foreach ($clm_fields as $fld) {
                    $columns_size = 1;
                    if (isset($fld['column_size'])) {
                        $columns_size = $fld['column_size'];
                    }
                    $field = ReonCore::process_default_field($fld);
                    $field['label'] = array();
                    $field['parent_id'] = $g_field['id'];
                    $field['center_head'] = false;
                    $field = ReonUtil::get_screen_args_from_field($g_field, $field);

                    if ($is_grey_parent == true) {
                        $field['grey-parent'] = true;
                    }

                    if (!isset($g_field['merge_fields']) || $g_field['merge_fields'] === true) {
                        $field['in_prefix'] = $g_field['in_prefix'] . $g_field['id'] . $g_field['in_postfix'] . '[';
                    } else {
                        $field['in_prefix'] = $g_field['in_prefix'];
                    }


                    $field['in_postfix'] = ']';

                    if (isset($field['fields']) && isset($field['merge_fields']) && $field['merge_fields'] === false) {
                        $field_ids = ReonUtil::get_controls_field_ids($field['fields']);
                        foreach ($field_ids as $field_id) {
                            if (isset($g_field['value'][$field_id])) {
                                $field['value'][$field_id] = $g_field['value'][$field_id];
                            }
                        }
                    } else if (isset($g_field['value'][$field['id']])) {
                        $field['value'] = $g_field['value'][$field['id']];
                    } else {
                        if (isset($field['default'])) {
                            $field['value'] = $field['default'];
                        }
                    }
                    $column_title = '';

                    if (isset($field['column_title'])) {
                        $tooltip = '';
                        ob_start();
                        do_action('reon/render-control-tooltip', $field['tooltip']);
                        $tooltip = ob_get_clean();
                        $field['tooltip'] = array('title' => '');
                        $column_title = '<h6 class="rn-columns-title">' . esc_html($field['column_title']) . $tooltip . '</h6>';
                    }

                    $col_attr = array(
                        'style' => 'width:' . ($columns_size / $total_columns) * 100 . '%;',
                        'class' => ReonUtil::array_to_classes(apply_filters('reon/control-columns-classes', array(), $field)),
                    );
                    ?>
                    <td <?php echo ReonUtil::array_to_attributes(apply_filters('reon/control-columns-attributes', $col_attr, $field)); ?>>
                        <?php echo $column_title; ?>
                        <?php do_action('reon/render-control-' . $field['type'], $field); ?>        
                    </td>
                    <?php
                }
            }
            ?>
        </tr>   
    </table>
</div>