(function ($) {
    "use strict";
    $.fn.rn_autoid = function (options) {



        return this.each(function () {
            // Default options.

            var settings = $.extend({
                autoid_id: 'autoid',
                autoid_prefix: '',
                autoid_suffix: '',
            }, options);

            var obj = $(this);
            var opt = settings;
            prepere_options(obj);


            if (obj.val() == '') {
                obj.val(get_autoid_value(settings.autoid_id, settings.autoid_prefix, settings.autoid_suffix));
            }

            function get_autoid_value(autoid, prefix, suffix) {
                var auto_value = 0;
                if (jQuery.data(document.body, autoid)) {
                    auto_value = jQuery.data(document.body, autoid);
                } else {
                    var dt = new Date();
                    auto_value = dt.getTime();
                }

                auto_value++;
                jQuery.data(document.body, autoid, auto_value);

                return prefix + auto_value + suffix;
            }

            function prepere_options(optobj) {
                if (optobj.attr('data-autoid_id') && optobj.attr('data-autoid_id') != '') {
                    opt.autoid_id = optobj.attr('data-autoid_id');
                }

                if (optobj.attr('data-autoid_prefix')) {
                    opt.autoid_prefix = optobj.attr('data-autoid_prefix');
                }
                if (optobj.attr('data-autoid_suffix')) {
                    opt.autoid_suffix = optobj.attr('data-autoid_suffix');
                }
            }
        });


    };

}(jQuery));

