<?php

load_plugin_textdomain('zc-woo-pricely', false, dirname(plugin_basename(__FILE__)) . '/languages/');

if (!defined('WOO_PRICELY_ASSETS_URL')) {
    define('WOO_PRICELY_ASSETS_URL', plugins_url('assets/', __FILE__));
}

if (!defined('WOO_PRICELY_VERSION')) {
    define('WOO_PRICELY_VERSION', 'v1.3.5');
}

if (!function_exists('zc_pri_pricely_reon_loaded')) {

    function zc_pri_pricely_reon_loaded() {
        require_once (dirname(__FILE__) . '/admin/settings-page.php');
    }

}
add_action('reon/init', 'zc_pri_pricely_reon_loaded');


if (!function_exists('zc_pri_woo_pricely_init')) {

    function zc_pri_woo_pricely_init() {
        require_once (dirname(__FILE__) . '/inc/class-woopricely-util.php');
        require_once (dirname(__FILE__) . '/inc/class-woopricely-validation-util.php');
        require_once (dirname(__FILE__) . '/inc/class-woopricely.php');
        require_once (dirname(__FILE__) . '/inc/class-woopricely-cart-totals.php');
        require_once (dirname(__FILE__) . '/inc/class-woopricely-countdown.php');
        require_once (dirname(__FILE__) . '/inc/class-woopricely-product-prices.php');
        require_once (dirname(__FILE__) . '/inc/woopricely-checkout-prices/class-woopricely-checkout-prices.php');
        require_once (dirname(__FILE__) . '/inc/class-woopricely-checkout-discounts.php');
        require_once (dirname(__FILE__) . '/inc/class-woopricely-checkout-fees.php');
        require_once (dirname(__FILE__) . '/inc/class-woopricely-views.php');
        require_once (dirname(__FILE__) . '/inc/class-woopricely-cart-notifications.php');
        require_once (dirname(__FILE__) . '/inc/class-woopricely-cart.php');
        require_once (dirname(__FILE__) . '/inc/hooks.php');
        require_once (dirname(__FILE__) . '/inc/hooks-discounts-total.php');
        require_once (dirname(__FILE__) . '/inc/hooks-metrics-table.php');
        require_once (dirname(__FILE__) . '/inc/hooks-promo-message.php');
        require_once (dirname(__FILE__) . '/inc/hooks-live-price.php');
        require_once (dirname(__FILE__) . '/inc/hooks-countdown.php');
    }

}
add_action('woocommerce_init', 'zc_pri_woo_pricely_init');


if (!function_exists('zc_pri_woo_pricely_enqueue_frontend')) {

    function zc_pri_woo_pricely_enqueue_frontend() {
        global $zc_pri;



        wp_enqueue_style('dashicons');
        wp_enqueue_style('tipTip', WOO_PRICELY_ASSETS_URL . 'tipTip.css', array(), '1.2', 'all');
        wp_enqueue_style('woo_pricely_css', WOO_PRICELY_ASSETS_URL . 'styles.css', array(), '1.0', 'all');
        wp_enqueue_script('jquery-tipTip', WOO_PRICELY_ASSETS_URL . 'jquery.tipTip.min.js', array('jquery'), '1.3', true);
        wp_enqueue_script('jquery_countdown', WOO_PRICELY_ASSETS_URL . 'jquery.countdown.min.js', array('jquery'), '2.1.0', true);
        wp_enqueue_script('woo_pricely_js', WOO_PRICELY_ASSETS_URL . 'script.js', array('jquery'), '1.0', true);

        //Custom CSS
        if (isset($zc_pri['custom_css']) && $zc_pri['custom_css'] != '') {
            $custom_css = $zc_pri['custom_css'];
            wp_add_inline_style('woo_pricely_css', $custom_css);
        }
    }

}

add_action('wp_enqueue_scripts', 'zc_pri_woo_pricely_enqueue_frontend');

if (!function_exists('zc_pri_woo_pricely_enqueue_backend')) {

    function zc_pri_woo_pricely_enqueue_backend() {

        wp_enqueue_style('woo_pricely_admin_css', WOO_PRICELY_ASSETS_URL . 'admin-syles.css', array(), '1.0', 'all');
    }

}
add_action('admin_enqueue_scripts', 'zc_pri_woo_pricely_enqueue_backend', 20);




