<?php

if (!defined('ABSPATH')) {
    exit;
}


if (!class_exists('WooPricely_Cart')) {

    class WooPricely_Cart {

        private static $cart_products = array();
        private static $calculating = false;
        private static $mini_cart_subtotal = false;

        public static function init() {
            add_action('woocommerce_before_calculate_totals', array(new self(), 'before_calculate_totals'), 9999990);
            add_action('woocommerce_cart_loaded_from_session', array(new self(), 'cart_loaded_from_session'), 9999990);

            add_filter('woocommerce_cart_get_subtotal', array(new self(), 'get_mini_cart_subtotal'), 9999990, 1);
            add_filter('woocommerce_cart_get_subtotal_tax', array(new self(), 'get_mini_subtotal_tax'), 9999990, 1);

            add_action('wp_loaded', 'WooPricely::clear_cart_auto_add');


            add_filter('woocommerce_product_get_price', array(new self(), 'get_product_sale_price'), 9999990, 2);
            add_filter('woocommerce_product_variation_get_price', array(new self(), 'get_product_sale_price'), 9999990, 2);
        }

        public static function get_cart_discounts($catch = true) {
            if ($catch == true) {
                if (count(self::$cart_products) == 0) {
                    self::$cart_products = WooPricely_Checkout_Prices::calculate_product_prices();
                }
            } else {
                self::$cart_products = WooPricely_Checkout_Prices::calculate_product_prices();
            }
            return self::$cart_products;
        }

        public static function get_cart_discount($key) {
            self::get_cart_discounts();
            foreach (self::$cart_products as $cart_discount) {
                if ($cart_discount['cart_key'] == $key) {
                    return $cart_discount;
                }
            }
            return array();
        }

        public static function before_calculate_totals($cart_object) {
            if (is_admin()) {
                return;
            }

            if (self::$calculating == true) {
                return;
            }

            self::$calculating = true;
            if (WC()->cart->is_empty()) {
                WooPricely::clear_cart_auto_add();
                self::$calculating = false;
                return;
            }

            self::apply_checout_prices($cart_object);
            self::$calculating = false;
        }

        public static function cart_loaded_from_session($cart_object) {
            self::apply_checout_prices($cart_object);
        }

        public static function apply_checout_prices($cart_object) {
            foreach ($cart_object->get_cart() as $key => $cart_item) {
                $cart_discount = self::get_cart_discount($key);

                if (isset($cart_discount['discount_price'])) {
                    $cart_item['data']->set_price($cart_discount['discount_price']);
                } else if (isset($cart_item['zc_pri_cart_price'])) {
                    $cart_item['data']->set_price($cart_item['zc_pri_cart_price']);
                } else if (isset($cart_discount['cart_price'])) {
                    $cart_item['data']->set_price($cart_discount['cart_price']);
                }
            }
        }

        public static function refresh_cart() {
            
            WC()->cart->calculate_totals();
            self::apply_checout_prices(WC()->cart);
        }

        public static function do_mini_cart_before() {
            self::$mini_cart_subtotal = true;
        }

        public static function do_mini_cart_after() {

            self::$mini_cart_subtotal = false;
        }

        public static function get_mini_cart_subtotal($subtotals) {
//            if (self::$mini_cart_subtotal == false) {
//                return $subtotals;
//            }

            if (self::is_cart_or_checkout_price()) {
                return $subtotals;
            }

            $cart_discounts = self::get_cart_discounts(true);

            if (count($cart_discounts) > 0) {
                $c_subtotals = 0;
                $d_subtotals = 0;

                foreach ($cart_discounts as $cart_discount) {
                    $d_subtotals += $cart_discount['discount_price'] * $cart_discount['qty'];
                    $c_subtotals += $cart_discount['cart_price'] * $cart_discount['qty'];
                }

                if ($c_subtotals > $d_subtotals) {
                    $discount_totals = $c_subtotals - $d_subtotals;
                    return $subtotals - $discount_totals;
                } else if ($d_subtotals > $c_subtotals) {
                    $discount_totals = $d_subtotals - $c_subtotals;
                    return $subtotals + $discount_totals;
                }
            }
            return $subtotals;
        }

        public static function get_mini_subtotal_tax($subtotals_tax) {
//            if (self::$mini_cart_subtotal == false) {
//                return $subtotals_tax;
//            }

            if (self::is_cart_or_checkout_price()) {
                return $subtotals_tax;
            }


            $cart_discounts = self::get_cart_discounts(true);

            if (count($cart_discounts) > 0) {
                $c_subtotals_tax = 0;
                $d_subtotals_tax = 0;

                foreach ($cart_discounts as $cart_discount) {
                    $d_subtotals_tax += WooPricely_Cart_Totals::get_product_tax($cart_discount['key'], $cart_discount['discount_price'], $cart_discount['qty']);
                    $c_subtotals_tax += WooPricely_Cart_Totals::get_product_tax($cart_discount['key'], $cart_discount['cart_price'], $cart_discount['qty']);
                }

                if ($c_subtotals_tax > $d_subtotals_tax) {
                    $discount_totals_tax = $c_subtotals_tax - $d_subtotals_tax;
                    return $subtotals_tax - $discount_totals_tax;
                } else if ($d_subtotals_tax > $c_subtotals_tax) {
                    $discount_totals_tax = $d_subtotals_tax - $c_subtotals_tax;
                    return $subtotals_tax + $discount_totals_tax;
                }
            }

            return $subtotals_tax;
        }

        public static function get_product_sale_price($price, $src_product) {

            if (self::$calculating == true) {
                return $price;
            }
            self::$calculating = true;
            
            if (self::is_cart_or_checkout_price()) {

                $product_id = $src_product->get_id();

                self::get_cart_discounts();
                
                foreach (self::$cart_products as $product) {
                    if ($product['id'] == $product_id) {
                        self::$calculating = false;
                        return $product['discount_price'];
                    }
                }
            }
            self::$calculating = false;
            return $price;
        }

        private static function is_cart_or_checkout_price() {
            if (defined('WOOCOMMERCE_CART') || defined('WOOCOMMERCE_CHECKOUT')) {
                return true;
            }
            return false;
        }

    }

    WooPricely_Cart::init();
}



