<?php

add_filter('reon/get-option-page-' . $option_name . '-sections', 'dpd_get_config_products_price_section', 20);

function dpd_get_config_products_price_section($in_sections) {
    $in_sections[] = array(
        'title' => __('Products Pricing', 'zc-woo-pricely'),
        'id' => 'product_price',
//        'group' => 1
    );
    return $in_sections;
}

add_filter('get-option-page-' . $option_name . 'section-product_price-fields', 'zc_get_dpd_config_sections_product_price');

function zc_get_dpd_config_sections_product_price($in_fields) {
    $in_fields[] = array(
        'id' => 'module_title',
        'type' => 'paneltitle',
        'full_width' => true,
        'center_head' => true,
        'title' => __('Product Pricing Rules', 'zc-woo-pricely'),
        'desc' => __('Create unlimited number product pricing rules', 'zc-woo-pricely'),
    );
   
    $in_fields[] = array(
        'id' => 'products_pricing',
        'type' => 'panel',
        'last' => true,
        'white_panel' => false,
        'panel_size' => 'smaller',
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'any_id',
                'type' => 'columns-field',
                'columns' => 7,
                'merge_fields' => false,
                'fields' => array(
                    array(
                        'id' => 'max_discount_type',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Discount Limit Per Product', 'zc-woo-pricely'),
                        'tooltip' => __('Controls discount pricing limit per product', 'zc-woo-pricely'),
                        'default' => 'before_add_to_cart',
                        'options' => array(
                            'no' => __('No limit', 'zc-woo-pricely'),
                            'amount' => __('Discount amount', 'zc-woo-pricely'),
                            'per' => __('Percentage Discount', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                        'fold_id' => 'max_discount_type',
                    ),
                    array(
                        'id' => 'max_discount_amount',
                        'type' => 'textbox',
                        'input_type' => 'number',
                        'column_size' => 2,
                        'column_title' => __('Limit', 'zc-woo-pricely'),
                        'tooltip' => __('Controls discount limit amount', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('0.00', 'zc-woo-pricely'),
                        'width' => '100%',
                        'attributes' => array(
                            'min' => '0',
                            'step' => '1',
                        ),
                        'fold' => array(
                            'target' => 'max_discount_type',
                            'attribute' => 'value',
                            'value' => 'no',
                            'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => true,
                        ),
                    ),
                    array(
                        'id' => 'mode',
                        'type' => 'select2',
                        'column_size' => 3,
                        'column_title' => __('Rules Apply Mode Per Product', 'zc-woo-pricely'),
                        'tooltip' => __('Controls pricing rules apply mode', 'zc-woo-pricely'),
                        'default' => 'yes',
                        'options' => array(
                            'all' => __('Apply all valid rules', 'zc-woo-pricely'),
                            'bigger' => __('Apply rules with bigger price per product', 'zc-woo-pricely'),
                            'smaller' => __('Apply rules with smaller price per product', 'zc-woo-pricely'),
                            'first' => __('Apply first valid rule per product', 'zc-woo-pricely'),
                            'last' => __('Apply last valid rule per product', 'zc-woo-pricely'),
                            'no' => __('Do not apply any rule', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                ),
            ),
        ),
    );

     
    $in_fields[] = array(
        'id' => 'products_pricing_rules',
        'type' => 'repeater',
        'full_width' => true,
        'center_head' => true,
        'white_repeater' => false,
        'repeater_size' => 'small',
        'accordions' => true,
        'buttons_sep' => false,
        'delete_button' => true,
        'clone_button' => true,        
        'width' => '100%',
        'auto_expand' => array(
            'new_section' => true,
            'cloned_section' => true,
        ),
        'sortable' => array(
            'enabled' => true,
        ),
        'template_adder' => array(
            'position' => 'right',
            'show_list' => false,
            'button_text' => __('Add Pricing Rule', 'zc-woo-pricely'),
        ),
    );


    return $in_fields;
}


