<?php

if (!class_exists('Reon')) {
    return;
}

$option_name = "zc_pri";

$args = array(
    'option_name' => $option_name,
    'database' => 'option',
    'default_min_height' => '700px',
    'width' => 'auto',
    'aside_width' => '210px',
    'display' => array(
        'enabled' => true,
        'image' => WOO_PRICELY_ASSETS_URL . 'images/aside_logo.png',
        'title' => __('WooPricely', 'zc-woo-pricely'),
        'sub_title' => 'Dynamic Pricing, Fees & Discounts',
        'version' => WOO_PRICELY_VERSION,
        'styles' => array(
            'bg_image' => WOO_PRICELY_ASSETS_URL . 'images/aside_bg.png',
            'bg_color' => '#0073aa',
            'color' => '#fff',
            'height' => '215px',
        ),
    ),
    'ajax' => array(
        'save_msg' => __('Done!!', 'zc-woo-pricely'),
        'save_error_msg' => __('Unable to save your settings', 'zc-woo-pricely'),
        'reset_msg' => __('Done!!', 'zc-woo-pricely'),
        'reset_error_msg' => __('Unable to reset reset your settings', 'zc-woo-pricely'),
        'nonce_error_msg' => __('invalid nonce', 'zc-woo-pricely'),
    ),
    'menu' => array(
        'enable' => true,
        'slug' => 'zc_pri',
        'title' => __('WooPricely', 'zc-woo-pricely'),
        'page_title' => __('WooPricely', 'zc-woo-pricely'),
        'icon' => 'dashicons-admin-generic',
        'priority' => '999', //999
        'parent' => 'woocommerce',
        'base_url'=> 'admin.php',
        'capability' => 'manage_woocommerce',
    ),
    'import_export' => array(
        'enable' => true,
        'min_height' => '565px',
        'title' => __('Import / Export', 'zc-woo-pricely'),
        'import' => array(
            'title' => __('Import Settings', 'zc-woo-pricely'),
            'desc' => __('Here you can import new settings. Simply paste the settings url or data on the field below.', 'zc-woo-pricely'),
            'url_button_text' => __('Import from url', 'zc-woo-pricely'),
            'url_textbox_desc' => __("Paste the url to another site's settings below and click the 'Import Now' button.", 'zc-woo-pricely'),
            'url_textbox_hint' => __("Paste the url to another site's settings here...", 'zc-woo-pricely'),
            'data_button_text' => __('Import Data', 'zc-woo-pricely'),
            'data_textbox_desc' => __("Paste your backup settings below and click the 'Import Now' button.", 'zc-woo-pricely'),
            'data_textbox_hint' => __('Paste your backup settings here...', 'zc-woo-pricely'),
            'import_button_text' => __('Import Now', 'zc-woo-pricely'),
            'warn_text' => __('Warning! This will override all existing settings. proceed with caution!', 'zc-woo-pricely'),
        ),
        'export' => array(
            'title' => __('Export Settings', 'zc-woo-pricely'),
            'desc' => __('Here you can backup your current settings. You can later use it to restore your settings.', 'zc-woo-pricely'),
            'download_button_text' => __('Download Data', 'zc-woo-pricely'),
            'url_button_text' => __('Export url', 'zc-woo-pricely'),
            'url_textbox_desc' => __('Copy the url below, use it to transfer the settings from this site.', 'zc-woo-pricely'),
            'data_button_text' => __('Export Data', 'zc-woo-pricely'),
            'data_textbox_desc' => __('Copy the data below, use it as your backup.', 'zc-woo-pricely'),
        ),
    ),
    'header_buttons' => array(
        'reset_all_text' => __('Reset All', 'zc-woo-pricely'),
        'reset_section_text' => __('Reset Section', 'zc-woo-pricely'),
        'save_all_text' => __('Save All', 'zc-woo-pricely'),
        'save_section_text' => __('Save Section', 'zc-woo-pricely'),
    ),
    'footer_buttons' => array(
        'reset_all_text' => __('Reset All', 'zc-woo-pricely'),
        'reset_section_text' => __('Reset Section', 'zc-woo-pricely'),
        'save_all_text' => __('Save All', 'zc-woo-pricely'),
        'save_section_text' => __('Save Section', 'zc-woo-pricely'),
    ),
    'page_links' => array(
        array(
            'id' => 'zc_pri_help',
            'title' => __('Help', 'zc-woo-pricely'),
            'icon' => 'fa fa-question-circle',
            'href' => 'https://codecanyon.net/item/woopricely-dynamic-pricing-fees-discounts/23844181/comments?ref=zendcrew',
            'target' => '_blank',
            'show_in' => 'both' // page, admin_bar or both
        ),
        array(
            'id' => 'zc_pri_documentation',
            'title' => __('Documentation', 'zc-woo-pricely'),
            'icon' => 'fa fa-file-text-o',
            'href' => 'https://support.zendcrew.com/woo-pricely/',
            'target' => '_blank',
            'show_in' => 'both' // page, admin_bar or both
        ),
    ),
    'social_links' => array(
        array(
            'id' => 'zc_pri_facebook',
            'title' => __('Facebook', 'zc-woo-pricely'),
            'icon' => 'fa fa-facebook',
            'href' => 'http://www.facebook.com/zendcrew',
            'target' => '_blank',
        ),
        array(
            'id' => 'zc_pri_linkedin',
            'title' => __('LinkedIn', 'zc-woo-pricely'),
            'icon' => 'fa fa-linkedin',
            'href' => 'https://www.linkedin.com/company/zendcrew',
            'target' => '_blank',
        ),
        array(
            'id' => 'zc_pri_stack_overflow',
            'title' => __('Stack Overflow', 'zc-woo-pricely'),
            'icon' => 'fa fa-stack-overflow',
            'href' => 'https://stackoverflow.com/users/8692713/zendcrew',
            'target' => '_blank',
        ),
        array(
            'id' => 'zc_pri_instagram',
            'title' => __('Instagram', 'zc-woo-pricely'),
            'icon' => 'fa fa-instagram',
            'href' => 'https://www.instagram.com/zendcrew/',
            'target' => '_blank',
        ),
    ),
);


Reon::set_option_page($args);


require_once (dirname(__FILE__) . '/admin-functions.php');
require_once (dirname(__FILE__) . '/admin-hooks/admin-hooks.php');

require_once (dirname(__FILE__) . '/settings-general.php');
require_once (dirname(__FILE__) . '/settings-products-pricing.php');
require_once (dirname(__FILE__) . '/settings-checkout-pricing.php');
require_once (dirname(__FILE__) . '/settings-checkout-discounts.php');
require_once (dirname(__FILE__) . '/settings-checkout-fees.php');
//





add_filter('reon/process-save-options-' . $option_name, 'sanitize_zc_pri_options', 10);


//==================
// Sanitize Settings
//==================
if (!function_exists('sanitize_zc_pri_options')) {

    function sanitize_zc_pri_options($options) {
        if (isset($options['products_pricing_rules'])) {
            $options['products_pricing_rules'] = sanitize_zc_pri_product_prices_options($options['products_pricing_rules']);
        }

        if (isset($options['checkout_price_rules'])) {
            $options['checkout_price_rules'] = sanitize_zc_pri_checkout_prices_options($options['checkout_price_rules']);
        }

        if (isset($options['checkout_discounts_rules'])) {
            $options['checkout_discounts_rules'] = sanitize_zc_pri_checkout_discounts_options($options['checkout_discounts_rules']);
        }

        if (isset($options['checkout_fees_rules'])) {
            $options['checkout_fees_rules'] = sanitize_zc_pri_checkout_fees_options($options['checkout_fees_rules']);
        }


        return $options;
    }

}
//==================================
// Sanitize product pricing settings
//==================================
if (!function_exists('sanitize_zc_pri_product_prices_options')) {

    function sanitize_zc_pri_product_prices_options($rules) {

        for ($i = 0; $i < count($rules); $i++) {
            if ($rules[$i]['price_mode'] == 'sale_price') {
                unset($rules[$i]['regular_adj']);
                unset($rules[$i]['clear_sale_price']);
                if ($rules[$i]['schedule_sale']['enable'] == 'no') {
                    unset($rules[$i]['schedule_sale']['from']);
                    unset($rules[$i]['schedule_sale']['to']);
                }
            } else if ($rules[$i]['price_mode'] == 'regular_price') {
                unset($rules[$i]['sale_adj']);
                unset($rules[$i]['schedule_sale']);
            } else {
                unset($rules[$i]['clear_sale_price']);

                if ($rules[$i]['schedule_sale']['enable'] == 'no') {
                    unset($rules[$i]['schedule_sale']['from']);
                    unset($rules[$i]['schedule_sale']['to']);
                }
            }
        }

        return $rules;
    }

}

//===================================
// Sanitize checkout pricing settings
//===================================
if (!function_exists('sanitize_zc_pri_checkout_prices_options')) {

    function sanitize_zc_pri_checkout_prices_options($rules) {

        for ($i = 0; $i < count($rules); $i++) {
            $rule_mode = $rules[$i]['mode'];
            $rule = apply_filters('zcpri/sanitize-checkout-prices-' . $rule_mode . '-rule-settings', $rules[$i]);

            if (!isset($rule['conditions']) && isset($rules[$i]['conditions'])) {
                $rule['conditions'] = $rules[$i]['conditions'];
            }

            if (!isset($rule['admin_note'])) {
                $rule['admin_note'] = $rules[$i]['admin_note'];
            }

            if (!isset($rule['message'])) {
                $rule['message'] = $rules[$i]['message'];
            }

            if (!isset($rule['notification'])) {
                $rule['notification'] = $rules[$i]['notification'];
            }

            $rule['mode'] = $rules[$i]['mode'];
            $rule['apply_mode'] = $rules[$i]['apply_mode'];
            $rule['enable'] = $rules[$i]['enable'];

            $rules[$i] = $rule;
        }
//        print_r($rule);
        return $rules;
    }

}

//=====================================
// Sanitize checkout discounts settings
//=====================================
if (!function_exists('sanitize_zc_pri_checkout_discounts_options')) {

    function sanitize_zc_pri_checkout_discounts_options($rules) {

        for ($i = 0; $i < count($rules); $i++) {
            if ($rules[$i]['send_to_group'] == 'yes') {
                unset($rules[$i]['single']);
            } else {
                unset($rules[$i]['group']);
            }

            if ($rules[$i]['discount']['discount_type'] == 'fixed_discount' || $rules[$i]['discount']['discount_type'] == 'per_discount') {
                unset($rules[$i]['discount']['item_base_on']);
            } else {
                unset($rules[$i]['discount']['cart_base_on']);
            }
        }




        return $rules;
    }

}

//================================
// Sanitize checkout fees settings
//================================
if (!function_exists('sanitize_zc_pri_checkout_fees_options')) {

    function sanitize_zc_pri_checkout_fees_options($rules) {

        for ($i = 0; $i < count($rules); $i++) {
            if ($rules[$i]['send_to_group'] == 'yes') {
                unset($rules[$i]['single']);
            } else {
                unset($rules[$i]['group']);
            }


            if ($rules[$i]['fee']['fee_type'] == 'fixed_fee' || $rules[$i]['fee']['fee_type'] == 'per_fee') {
                unset($rules[$i]['fee']['item_base_on']);
            } else {
                unset($rules[$i]['fee']['cart_base_on']);
            }
        }




        return $rules;
    }

}


add_filter('reon/field-classes', 'zc_pri_get_add_cssclasses', 20, 2);

if (!function_exists('zc_pri_get_add_cssclasses')) {

    function zc_pri_get_add_cssclasses($css_classes, $field) {

        if ($field['id'] == 'products_pricing_rules' || $field['id'] == 'checkout_price_rules' || $field['id'] == 'checkout_discounts_rules' || $field['id'] == 'checkout_fees_rules') {
            $css_classes[] = 'zcpri_module_rules';
        }

        if ($field['id'] == 'checkout_fees' || $field['id'] == 'checkout_discounts' || $field['id'] == 'checkout_prices' || $field['id'] == 'products_pricing') {
            $css_classes[] = 'zcpri_module_max';
        }
        if ($field['id'] == 'module_title') {
            $css_classes[] = 'zcpri_module_title';
        }

        return $css_classes;
    }

}
