<?php

add_filter('reon/get-option-page-' . $option_name . '-sections', 'zc_pri_get_config_basic_section', 10);

function zc_pri_get_config_basic_section($in_sections) {
    $in_sections[] = array(
        'title' => __('General Settings', 'zc-woo-pricely'),
        'id' => 'general-settings',
    );

    return $in_sections;
}

add_filter('get-option-page-' . $option_name . 'section-general-settings-fields', 'zc_pri_get_sections_general_settings');

function zc_pri_get_sections_general_settings($in_fields) {


    $in_fields[] = array(
        'id' => 'metrics_tables',
        'type' => 'panel',
        'last' => true,
        'white_panel' => false,
        'panel_size' => 'smaller',
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'any_id',
                'type' => 'paneltitle',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Quantity Metrics Table', 'zc-woo-pricely'),
                'desc' => __('Use this panel to apply volume metrics table settings on single product pages', 'zc-woo-pricely'),
            ),
            array(
                'id' => 'any_id',
                'type' => 'columns-field',
                'columns' => 6,
                'merge_fields' => false,
                'fields' => array(
                    array(
                        'id' => 'enable',
                        'type' => 'select2',
                        'title' => __('Enable', 'zc-woo-pricely'),
                        'column_size' => 1,
                        'column_title' => __('Enable', 'zc-woo-pricely'),
                        'tooltip' => __('Enables all volume metrics tables on single product pages', 'zc-woo-pricely'),
                        'default' => 'yes',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'position',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Position', 'zc-woo-pricely'),
                        'tooltip' => __('Controls metrics tables position on single product pages', 'zc-woo-pricely'),
                        'default' => 'product_summary_21',
                        'minimum_results_forsearch' => 15,
                        'options' => array(
                            'product_summary_4' => __('Before Product Title', 'zc-woo-pricely'),
                            'product_summary_6' => __('After Product Title', 'zc-woo-pricely'),
                            'product_summary_11' => __('After Price', 'zc-woo-pricely'),
                            'product_summary_21' => __('After Short Description', 'zc-woo-pricely'),
                            'product_summary_31' => __('After Add To Cart', 'zc-woo-pricely'),
                            'product_summary_41' => __('After Product Meta', 'zc-woo-pricely'),
                            'product_summary_51' => __('After Share Buttons', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'layout',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Layout', 'zc-woo-pricely'),
                        'tooltip' => __('Controls metrics tables layout on single product pages', 'zc-woo-pricely'),
                        'default' => 'horizontal',
                        'options' => array(
                            'horizontal' => __('Horizontal', 'zc-woo-pricely'),
                            'vertical' => __('Vertical', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'show_headers',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Show Headers', 'zc-woo-pricely'),
                        'tooltip' => __('Shows all table headers', 'zc-woo-pricely'),
                        'default' => 'yes',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                ),
            ),
            array(
                'id' => 'tables',
                'type' => 'repeater',
                'filter_id' => 'metrics_tables',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Metrics Tables', 'zc-woo-pricely'),
                'desc' => __('Use this panel to create multiple volume metrics tables', 'zc-woo-pricely'),
                'white_repeater' => true,
                'repeater_size' => 'smaller',
                'accordions' => true,
                'buttons_sep' => false,
                'default' => array(array('group_type' => 'default')),
                'width' => '100%',
                'auto_expand' => array(
                    'new_section' => true,
                    'cloned_section' => true,
                    'default_section' => false,
                ),
                'sortable' => array(
                    'enabled' => false,
                ),
                'static_template' => 'default',
                'section_type_id' => 'group_type',
                'template_adder' => array(
                    'position' => 'right',
                    'show_list' => false,
                    'button_text' => __('Add New Table', 'zc-woo-pricely'),
                ),
            ),
        ),
    );



    $in_fields[] = array(
        'id' => 'promo_message',
        'type' => 'panel',
        'last' => true,
        'white_panel' => false,
        'panel_size' => 'smaller',
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'any_id',
                'type' => 'paneltitle',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Promo Message Settings', 'zc-woo-pricely'),
                'desc' => __('Use this panel to apply promo message settings on single product pages', 'zc-woo-pricely'),
            ),
            array(
                'id' => 'any_id',
                'type' => 'columns-field',
                'columns' => 3,
                'merge_fields' => false,
                'fields' => array(
                    array(
                        'id' => 'enable',
                        'type' => 'select2',
                        'title' => __('Enable', 'zc-woo-pricely'),
                        'column_size' => 1,
                        'column_title' => __('Enable', 'zc-woo-pricely'),
                        'tooltip' => __('Enables promo message on single product pages', 'zc-woo-pricely'),
                        'default' => 'yes',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'position',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Position', 'zc-woo-pricely'),
                        'tooltip' => __('Controls promo message position on single product pages', 'zc-woo-pricely'),
                        'default' => 'product_summary_21',
                        'minimum_results_forsearch' => 15,
                        'options' => array(
                            'product_summary_4' => __('Before Product Title', 'zc-woo-pricely'),
                            'product_summary_6' => __('After Product Title', 'zc-woo-pricely'),
                            'product_summary_11' => __('After Price', 'zc-woo-pricely'),
                            'product_summary_21' => __('After Short Description', 'zc-woo-pricely'),
                            'product_summary_31' => __('After Add To Cart', 'zc-woo-pricely'),
                            'product_summary_41' => __('After Product Meta', 'zc-woo-pricely'),
                            'product_summary_51' => __('After Share Buttons', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                ),
            ),
        ),
    );
    
    
    $in_fields[] = array(
        'id' => 'notifications',
        'type' => 'panel',
        'last' => true,
        'white_panel' => false,
        'panel_size' => 'smaller',
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'any_id',
                'type' => 'paneltitle',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Cart/Checkout Notification Settings', 'zc-woo-pricely'),
                'desc' => __('Use this panel to apply notification messages on cart and checkout pages', 'zc-woo-pricely'),
            ),
            array(
                'id' => 'any_id',
                'type' => 'columns-field',
                'columns' => 3,
                'merge_fields' => false,
                'fields' => array(
                    array(
                        'id' => 'checkout_prices',
                        'type' => 'select2',                        
                        'column_size' => 1,
                        'column_title' => __('Enable Checkout Pricing Notifications', 'zc-woo-pricely'),
                        'tooltip' => __('Enables checkout pricing notifications on cart and checkout pages', 'zc-woo-pricely'),
                        'default' => 'no',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'checkout_discounts',
                        'type' => 'select2',                        
                        'column_size' => 1,
                        'column_title' => __('Enable Checkout Discounts Notifications', 'zc-woo-pricely'),
                        'tooltip' => __('Enables checkout discounts notifications on cart and checkout pages', 'zc-woo-pricely'),
                        'default' => 'no',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'checkout_fees',
                        'type' => 'select2',                        
                        'column_size' => 1,
                        'column_title' => __('Enable Checkout Fees Notifications', 'zc-woo-pricely'),
                        'tooltip' => __('Enables checkout fees notifications on cart and checkout pages', 'zc-woo-pricely'),
                        'default' => 'no',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                ),
            ),
        ),
    );


//live_pricing implementation here


    $in_fields[] = array(
        'id' => 'countdown_timer',
        'type' => 'columns-field',
        'last' => true,
        'panel' => true,
        'white_panel' => false,
        'panel_size' => 'small',
        'inner_title' => __('Countdown Timer Settings', 'zc-woo-pricely'),
        'inner_desc' => __('Use this panel to apply countdown timer settings on single product pages', 'zc-woo-pricely'),
        'columns' => 8,
        'fields' => array(
            array(
                'id' => 'enable',
                'type' => 'select2',
                'column_size' => 1,
                'column_title' => __('Enable', 'zc-woo-pricely'),
                'tooltip' => __('Enables countdoun timer on single product pages', 'zc-woo-pricely'),
                'default' => 'no',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'width' => '100%',
            ),
            array(
                'id' => 'time_left_mode',
                'type' => 'select2',
                'column_size' => 2,
                'column_title' => __('Time Left Mode', 'zc-woo-pricely'),
                'tooltip' => __('Time left controls when to show the countdown timer', 'zc-woo-pricely'),
                'default' => 'no',
                'options' => array(
                    'no' => __('Unlimited', 'zc-woo-pricely'),
                    'seconds' => __('Seconds', 'zc-woo-pricely'),
                    'minutes' => __('Minutes', 'zc-woo-pricely'),
                    'hours' => __('Hours', 'zc-woo-pricely'),
                    'days' => __('Days', 'zc-woo-pricely'),
                    'weeks' => __('Weeks', 'zc-woo-pricely'),
                    'months' => __('Months', 'zc-woo-pricely'),
                ),
                'width' => '100%',
                'fold_id' => 'time_left_mode',
            ),
            array(
                'id' => 'time_left',
                'type' => 'textbox',
                'input_type' => 'number',
                'column_size' => 1,
                'column_title' => __('Time Left', 'zc-woo-pricely'),
                'tooltip' => __('Time left controls when to show the countdown timer', 'zc-woo-pricely'),
                'default' => '1',
                'placeholder' => __('00', 'zc-woo-pricely'),
                'attributes' => array(
                    'min' => '1',
                    'step' => '1',
                ),
                'width' => '100%',
                'fold' => array(
                    'target' => 'time_left_mode',
                    'attribute' => 'value',
                    'value' => 'no',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
            ),
            array(
                'id' => 'position',
                'type' => 'select2',
                'column_size' => 2,
                'column_title' => __('Position', 'zc-woo-pricely'),
                'tooltip' => __('Controls countdoun timer position on single product pages', 'zc-woo-pricely'),
                'default' => 'product_summary_21',
                'options' => array(
                    'product_summary_4' => __('Before Product Title', 'zc-woo-pricely'),
                    'product_summary_6' => __('After Product Title', 'zc-woo-pricely'),
                    'product_summary_11' => __('After Price', 'zc-woo-pricely'),
                    'product_summary_21' => __('After Short Description', 'zc-woo-pricely'),
                    'product_summary_31' => __('After Add To Cart', 'zc-woo-pricely'),
                    'product_summary_41' => __('After Product Meta', 'zc-woo-pricely'),
                    'product_summary_51' => __('After Share Buttons', 'zc-woo-pricely'),
                ),
                'width' => '100%',
            ),
            array(
                'id' => 'title',
                'type' => 'textbox',
                'input_type' => 'text',
                'column_size' => 2,
                'column_title' => __('Title', 'zc-woo-pricely'),
                'tooltip' => __('Controls countdoun timer title on single product pages', 'zc-woo-pricely'),
                'default' => 'Discount Ends In',
                'placeholder' => __('Title', 'zc-woo-pricely'),
                'width' => '100%',
            ),
        ),
    );


    $in_fields[] = array(
        'id' => 'discounts_total',
        'type' => 'panel',
        'last' => true,
        'white_panel' => false,
        'panel_size' => 'smaller',
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'any_id',
                'type' => 'paneltitle',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Discounts Total Settings', 'zc-woo-pricely'),
                'desc' => __('Use this panel to apply discounts total settings on cart and checkout pages', 'zc-woo-pricely'),
            ),
            array(
                'id' => 'enable',
                'type' => 'group-field',
                'title' => __('Show Discounts Total', 'zc-woo-pricely'),
                'desc' => __('Enables discounts total amount on both cart and checkout pages', 'zc-woo-pricely'),
                'width' => '100%',
                'fields' => array(
                    array(
                        'id' => 'on_car',
                        'type' => 'select2',
                        'label' => array(
                            'title' => __('On Cart:', 'zc-woo-pricely'),
                        ),
                        'default' => 'yes_neg',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                            'yes_neg' => __('Yes (with minus)', 'zc-woo-pricely'),
                        ),
                        'width' => '152px',
                    ),
                    array(
                        'id' => 'on_checkout',
                        'type' => 'select2',
                        'label' => array(
                            'title' => __('On Checkout:', 'zc-woo-pricely'),
                        ),
                        'default' => 'yes_neg',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                            'yes_neg' => __('Yes (with minus)', 'zc-woo-pricely'),
                        ),
                        'width' => '152px',
                    ),
                ),
            ),
            array(
                'id' => 'titles',
                'type' => 'group-field',
                'title' => __('Titles', 'zc-woo-pricely'),
                'desc' => __('Controls discounts total titles on both cart and checkout pages', 'zc-woo-pricely'),
                'width' => '100%',
                'fields' => array(
                    array(
                        'id' => 'cart',
                        'type' => 'textbox',
                        'label' => array(
                            'title' => __('Cart:', 'zc-woo-pricely'),
                        ),
                        'default' => 'Discounts Total:',
                        'placeholder' => __('Discounts Total', 'zc-woo-pricely'),
                        'width' => '172px',
                    ),
                    array(
                        'id' => 'checkout',
                        'type' => 'textbox',
                        'label' => array(
                            'title' => __('Checkout:', 'zc-woo-pricely'),
                        ),
                        'default' => 'Discounts Total:',
                        'placeholder' => __('Discounts Total', 'zc-woo-pricely'),
                        'width' => '172px',
                    ),
                ),
            ),
            array(
                'id' => 'positions',
                'type' => 'group-field',
                'title' => __('Positions', 'zc-woo-pricely'),
                'desc' => __('Controls discounts total position on both cart and checkout pages', 'zc-woo-pricely'),
                'width' => '100%',
                'fields' => array(
                    array(
                        'id' => 'car',
                        'type' => 'select2',
                        'label' => array(
                            'title' => __('Cart:', 'zc-woo-pricely'),
                        ),
                        'default' => 'after_order_total',
                        'options' => array(
                            'before_shipping' => __('Shipping (Before)', 'zc-woo-pricely'),
                            'after_shipping' => __('Shipping (After)', 'zc-woo-pricely'),
                            'before_order_total' => __('Totals (Before)', 'zc-woo-pricely'),
                            'after_order_total' => __('Totals (After)', 'zc-woo-pricely'),
                        ),
                        'width' => '172px',
                    ),
                    array(
                        'id' => 'checkout',
                        'type' => 'select2',
                        'label' => array(
                            'title' => __('Checkout:', 'zc-woo-pricely'),
                        ),
                        'default' => 'after_order_total',
                        'options' => array(
                            'before_cart_contents' => __('Products (Before)', 'zc-woo-pricely'),
                            'after_cart_contents' => __('Products (After)', 'zc-woo-pricely'),
                            'before_shipping' => __('Shipping (Before)', 'zc-woo-pricely'),
                            'after_shipping' => __('Shipping (After)', 'zc-woo-pricely'),
                            'before_order_total' => __('Totals (Before)', 'zc-woo-pricely'),
                            'after_order_total' => __('Totals (After)', 'zc-woo-pricely'),
                        ),
                        'width' => '172px',
                    ),
                ),
            ),
        ),
    );








    $in_fields[] = array(
        'id' => 'cart_discounts',
        'type' => 'panel',
        'last' => true,
        'white_panel' => false,
        'panel_size' => 'smaller',
        'width' => '100%',
        'merge_fields' => false,
        'fields' => array(
            array(
                'id' => 'discount_groups_mode',
                'type' => 'select2',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Grouped Discounts Apply Mode', 'zc-woo-pricely'),
                'desc' => __('Controls checkout grouped discounts apply mode', 'zc-woo-pricely'),
                'default' => 'yes',
                'options' => array(
                    'all' => __('Apply all group discounts', 'zc-woo-pricely'),
                    'bigger' => __('Apply bigger discount per group', 'zc-woo-pricely'),
                    'smaller' => __('Apply smaller discount per group', 'zc-woo-pricely'),
                    'first' => __('Apply first discount per group', 'zc-woo-pricely'),
                    'last' => __('Apply last discount  per group', 'zc-woo-pricely'),
                ),
                'width' => '350px',
            ),
            array(
                'id' => 'discount_coupon',
                'type' => 'columns-field',
                'last' => true,
                'columns' => 3,
                'panel' => true,
                'white_panel' => true,
                'panel_size' => 'small',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Checkout Discount Coupons', 'zc-woo-pricely'),
                'desc' => __('Use this panel to apply discounts as coupons', 'zc-woo-pricely'),
                'fields' => array(
                    array(
                        'id' => 'enable',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Apply As Coupons', 'zc-woo-pricely'),
                        'tooltip' => __('Applys checkout discounts as coupon codes', 'zc-woo-pricely'),
                        'default' => 'no',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'allow_others',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Allow other coupon codes', 'zc-woo-pricely'),
                        'tooltip' => __('Allows other coupons on the cart', 'zc-woo-pricely'),
                        'default' => 'yes',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'replace_labels',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Replace coupon labels', 'zc-woo-pricely'),
                        'tooltip' => __('Replaces coupon codes with discount labels', 'zc-woo-pricely'),
                        'default' => 'no',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                )
            ),
            array(
                'id' => 'discount_groups',
                'type' => 'repeater',
                'filter_id' => 'discount_groups',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Checkout Discount Groups', 'zc-woo-pricely'),
                'desc' => __('Multiple discounts can be assigned to a single group, use this controls to create those groups', 'zc-woo-pricely'),
                'white_repeater' => true,
                'repeater_size' => 'smaller',
                'accordions' => true,
                'buttons_sep' => false,
                'default' => array(array('group_type' => 'default')),
                'width' => '100%',
                'auto_expand' => array(
                    'new_section' => true,
                    'cloned_section' => true,
                    'default_section' => false,
                ),
                'sortable' => array(
                    'enabled' => false,
                ),
                'static_template' => 'default',
                'section_type_id' => 'group_type',
                'template_adder' => array(
                    'position' => 'right',
                    'show_list' => false,
                    'button_text' => __('Add Discount Group', 'zc-woo-pricely'),
                ),
            )
        ),
    );

    $in_fields[] = array(
        'id' => 'any_id',
        'type' => 'panel',
        'last' => true,
        'white_panel' => false,
        'panel_size' => 'smaller',
        'merge_fields' => false,
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'fee_groups_mode',
                'type' => 'select2',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Grouped Fees Apply Mode', 'zc-woo-pricely'),
                'desc' => __('Controls checkout grouped fees apply mode', 'zc-woo-pricely'),
                'default' => 'yes',
                'options' => array(
                    'all' => __('Apply all group fees', 'zc-woo-pricely'),
                    'bigger' => __('Apply bigger fee per group', 'zc-woo-pricely'),
                    'smaller' => __('Apply smaller fee per group', 'zc-woo-pricely'),
                    'first' => __('Apply first fee per group', 'zc-woo-pricely'),
                    'last' => __('Apply last fee  per group', 'zc-woo-pricely'),
                ),
                'width' => '350px',
            ),
            array(
                'id' => 'fee_groups',
                'type' => 'repeater',
                'filter_id' => 'fee_groups',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Checkout Fee Groups', 'zc-woo-pricely'),
                'desc' => __('Multiple fees can be assigned to a single group, use this controls to create those groups', 'zc-woo-pricely'),
                'white_repeater' => true,
                'repeater_size' => 'smaller',
                'accordions' => true,
                'buttons_sep' => false,
                'default' => array(array('group_type' => 'default')),
                'width' => '100%',
                'auto_expand' => array(
                    'new_section' => true,
                    'cloned_section' => true,
                    'default_section' => false,
                ),
                'sortable' => array(
                    'enabled' => false,
                ),
                'static_template' => 'default',
                'section_type_id' => 'group_type',
                'template_adder' => array(
                    'position' => 'right',
                    'show_list' => false,
                    'button_text' => __('Add Fee Group', 'zc-woo-pricely'),
                ),
            )
        ),
    );


    $in_fields[] = array(
        'id' => 'on_sale_products',
        'type' => 'panel',
        'last' => true,
        'white_panel' => false,
        'panel_size' => 'smaller',
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'any_id',
                'type' => 'paneltitle',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Products On Sale Query Settings', 'zc-woo-pricely'),
                'desc' => __('Use this panel to apply products on sale query settings, use <a href="https://docs.woocommerce.com/document/woocommerce-shortcodes/" target="_blank">WooCommerce shortcodes</a> to display your products', 'zc-woo-pricely'),
            ),
            array(
                'id' => 'any_id',
                'type' => 'columns-field',
                'columns' => 5,
                'merge_fields' => false,
                'fields' => array(
                    array(
                        'id' => 'enable',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Enable', 'zc-woo-pricely'),
                        'tooltip' => __('Enables products on sale query', 'zc-woo-pricely'),
                        'default' => 'no',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'fold_id' => 'on_sale_enable',
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'product_count',
                        'type' => 'textbox',
                        'input_type' => 'number',
                        'column_size' => 2,
                        'column_title' => __('Number of Products', 'zc-woo-pricely'),
                        'tooltip' => __('Controls the maximum total number of products to query', 'zc-woo-pricely'),
                        'default' => '15',
                        'placeholder' => __('0.00', 'zc-woo-pricely'),
                        'width' => '100%',
                        'attributes' => array(
                            'min' => '0',
                            'step' => '1',
                        ),
                        'fold' => array(
                            'target' => 'on_sale_enable',
                            'attribute' => 'value',
                            'value' => 'yes',
                            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => false,
                        ),
                    ),
                    array(
                        'id' => 'replace_default',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Replace Default On Sale Products', 'zc-woo-pricely'),
                        'tooltip' => __('Replaces woocommerce default products on sale', 'zc-woo-pricely'),
                        'default' => 'no',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'fold' => array(
                            'target' => 'on_sale_enable',
                            'attribute' => 'value',
                            'value' => 'yes',
                            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => false,
                        ),
                        'width' => '100%',
                    ),
                ),
            ),
        ),
    );

    $in_fields[] = array(
        'id' => 'any_id',
        'type' => 'panel',
        'last' => true,
        'white_panel' => false,
        'panel_size' => 'smaller',
        'width' => '100%',
        'merge_fields' => false,
        'fields' => array(
            array(
                'id' => 'checkout_prices_conditions_modes',
                'type' => 'simple-repeater',
                'filter_id' => 'checkout_prices_products_mode',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Checkout Pricing: Conditions Validation Modes', 'zc-woo-pricely'),
                'desc' => __('Use this panel to control checkout pricing validation mode for conditions', 'zc-woo-pricely'),
                'white_repeater' => true,
                'repeater_size' => 'smaller',
                'buttons_sep' => false,
                'buttons_box_width' => '65px',
                'width' => '100%',
                'default' => array(array('group_type' => 'mode')),
                'sortable' => array(
                    'enabled' => false,
                ),
                'template_adder' => array(
                    'position' => 'right', //left, right
                    'show_list' => false,
                    'button_text' => __('Add Validation Mode', 'zc-woo-pricely'),
                ),
            ),
        ),
    );


    $custom_css = ".zc_zri_promo{
       border: 1px solid #ffc000;
       background-color: #ffe38d;
       color: #5f4700;
}
.zc_pri_metrics_table table{
       border-top: 1px solid #ccc;
}
.zc_pri_metrics_table tr{
       border-bottom: 1px solid #ccc;
}
.zc_pri_metrics_table th,.zc_pri_metrics_table td{
       padding: 5px;
}";


    $in_fields[] = array(
        'id' => 'any_id',
        'type' => 'panel',
        'white_panel' => false,
        'panel_size' => 'smaller',
        'merge_fields' => false,
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'custom_css',
                'type' => 'textarea',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Custom CSS', 'zc-woo-pricely'),
                'desc' => __('Additional css for, promo message, metric tables, count down timer, discounts and fees html', 'zc-woo-pricely'),
                'default' => $custom_css,
                'placeholder' => __('Type here...', 'zc-woo-pricely'),
                'width' => '100%',
                'cols' => '80',
                'rows' => '5',
                'height' => '50px'
            )
        ),
    );

    return $in_fields;
}

//========================
//Discount Groups Repeater
//========================
add_filter('reon/get-repeater-field-discount_groups-templates', 'zc_pri_get_discount_groups_template', 10, 2);

function zc_pri_get_discount_groups_template($in_templates, $args) {

    if ($args['screen'] == 'option-page' && $args['option_name'] == 'zc_pri') {

        $in_templates[] = array(
            'id' => 'default',
            'head' => array(
                'title' => '',
                'title_field' => 'title',
                'defaut_title' => __('Grouped Discounts', 'zc-woo-pricely'),
            )
        );

        $in_templates[] = array(
            'id' => 'group',
            'head' => array(
                'title' => '',
                'title_field' => 'title',
                'defaut_title' => __('Grouped Discounts', 'zc-woo-pricely'),
            )
        );
    }

    return $in_templates;
}

add_filter('roen/get-repeater-template-discount_groups-default-fields', 'zc_pri_get_discount_groups_template_fields', 10, 2);
add_filter('roen/get-repeater-template-discount_groups-group-fields', 'zc_pri_get_discount_groups_template_fields', 10, 2);

function zc_pri_get_discount_groups_template_fields($in_fields, $args) {

    $in_fields[] = array(
        'id' => 'title',
        'type' => 'textbox',
        'title' => __('Title', 'zc-woo-pricely'),
        'desc' => __('Controls the discounts group label', 'zc-woo-pricely'),
        'default' => 'Grouped Discounts',
        'placeholder' => __('Type here...', 'zc-woo-pricely'),
        'width' => '400px',
    );

    $in_fields[] = array(
        'id' => 'desc',
        'type' => 'textbox',
        'title' => __('Description', 'zc-woo-pricely'),
        'desc' => __('Controls the discounts group description', 'zc-woo-pricely'),
        'default' => '',
        'placeholder' => __('Type here...', 'zc-woo-pricely'),
        'width' => '400px',
    );
    
    $in_fields[] = array(
        'id' => 'notification',
        'type' => 'textbox',
        'title' => __('Cart/Checkout Notification', 'zc-woo-pricely'),
        'desc' => __('Controls the notification message on cart and checkout pages', 'zc-woo-pricely'),
        'default' => '',
        'placeholder' => __('Type here...', 'zc-woo-pricely'),
        'width' => '400px',
    );

    $in_fields[] = array(
        'id' => 'min',
        'type' => 'textbox',
        'input_type' => 'number',
        'title' => __('Minimum Discount', 'zc-woo-pricely'),
        'desc' => __('Controls the discounts group minimum value', 'zc-woo-pricely'),
        'default' => '',
        'placeholder' => __('0 Minimum', 'zc-woo-pricely'),
        'attributes' => array(
            'min' => '0',
            'step' => '0.01',
        ),
        'width' => '400px',
    );

    $in_fields[] = array(
        'id' => 'max',
        'type' => 'textbox',
        'input_type' => 'number',
        'title' => __('Maximum Discount', 'zc-woo-pricely'),
        'desc' => __('Controls the discounts group maximum value', 'zc-woo-pricely'),
        'default' => '',
        'placeholder' => __('No Maximum', 'zc-woo-pricely'),
        'attributes' => array(
            'min' => '0',
            'step' => '0.01',
        ),
        'width' => '400px',
    );

    $in_fields[] = array(
        'id' => 'coupon_code',
        'type' => 'textbox',
        'title' => __('Coupon Code', 'zc-woo-pricely'),
        'desc' => __('Specify the coupon code for this discounts group', 'zc-woo-pricely'),
        'default' => '',
        'placeholder' => __('xx-xxxxx', 'zc-woo-pricely'),
        'width' => '400px',
    );

    $in_fields[] = array(
        'id' => 'always_show',
        'type' => 'select2',
        'title' => __('Always Show', 'zc-woo-pricely'),
        'desc' => __('Hide this discount group if discount value is zero', 'zc-woo-pricely'),
        'default' => 'no',
        'options' => array(
            'no' => __('No', 'zc-woo-pricely'),
            'yes' => __('Yes', 'zc-woo-pricely'),
        ),
        'width' => '400px',
    );

    return $in_fields;
}

//===================
//Fee Groups Repeater
//===================
add_filter('reon/get-repeater-field-fee_groups-templates', 'zc_pri_get_fee_groups_template', 10, 2);

function zc_pri_get_fee_groups_template($in_templates, $args) {

    if ($args['screen'] == 'option-page' && $args['option_name'] == 'zc_pri') {

        $in_templates[] = array(
            'id' => 'default',
            'head' => array(
                'title' => '',
                'title_field' => 'title',
                'defaut_title' => __('Grouped Discounts', 'zc-woo-pricely'),
            )
        );

        $in_templates[] = array(
            'id' => 'group',
            'head' => array(
                'title' => '',
                'title_field' => 'title',
                'defaut_title' => __('Grouped Discounts', 'zc-woo-pricely'),
            )
        );
    }

    return $in_templates;
}

add_filter('roen/get-repeater-template-fee_groups-default-fields', 'zc_pri_get_fee_groups_template_fields', 10, 2);
add_filter('roen/get-repeater-template-fee_groups-group-fields', 'zc_pri_get_fee_groups_template_fields', 10, 2);

function zc_pri_get_fee_groups_template_fields($in_fields, $args) {

    $in_fields[] = array(
        'id' => 'title',
        'type' => 'textbox',
        'title' => __('Title', 'zc-woo-pricely'),
        'desc' => __('Controls the fee group label', 'zc-woo-pricely'),
        'default' => 'Grouped Fees',
        'placeholder' => __('Type here...', 'zc-woo-pricely'),
        'width' => '400px',
    );

    $in_fields[] = array(
        'id' => 'desc',
        'type' => 'textbox',
        'title' => __('Description', 'zc-woo-pricely'),
        'desc' => __('Controls the fee group description', 'zc-woo-pricely'),
        'default' => '',
        'placeholder' => __('Type here...', 'zc-woo-pricely'),
        'width' => '400px',
    );

    $in_fields[] = array(
        'id' => 'notification',
        'type' => 'textbox',
        'title' => __('Cart/Checkout Notification', 'zc-woo-pricely'),
        'desc' => __('Controls the notification message on cart and checkout pages', 'zc-woo-pricely'),
        'default' => '',
        'placeholder' => __('Type here...', 'zc-woo-pricely'),
        'width' => '400px',
    );
    
    $in_fields[] = array(
        'id' => 'min',
        'type' => 'textbox',
        'input_type' => 'number',
        'title' => __('Minimum Fee', 'zc-woo-pricely'),
        'desc' => __('Controls the fees group minimum value', 'zc-woo-pricely'),
        'default' => '',
        'placeholder' => __('0 Minimum', 'zc-woo-pricely'),
        'attributes' => array(
            'min' => '0',
            'step' => '0.01',
        ),
        'width' => '400px',
    );

    $in_fields[] = array(
        'id' => 'max',
        'type' => 'textbox',
        'input_type' => 'number',
        'title' => __('Maximum Fee', 'zc-woo-pricely'),
        'desc' => __('Controls the fees group maximum value', 'zc-woo-pricely'),
        'default' => '',
        'placeholder' => __('No Maximum', 'zc-woo-pricely'),
        'attributes' => array(
            'min' => '0',
            'step' => '0.01',
        ),
        'width' => '400px',
    );

    $in_fields[] = array(
        'id' => 'taxable',
        'type' => 'select2',
        'title' => __('Tax Class', 'zc-woo-pricely'),
        'desc' => __('Specify the tax class for this fees group', 'zc-woo-pricely'),
        'default' => 'no',
        'options' => array(
            '--1' => __('Not Taxable', 'zc-woo-pricely'),
            '' => __('Standard', 'zc-woo-pricely'),
        ),
        'data' => 'wc:tax_classes',
        'width' => '400px',
    );



    $in_fields[] = array(
        'id' => 'always_show',
        'type' => 'select2',
        'title' => __('Always Show', 'zc-woo-pricely'),
        'desc' => __('Hide this fee group if fee value is zero', 'zc-woo-pricely'),
        'default' => 'no',
        'options' => array(
            'no' => __('No', 'zc-woo-pricely'),
            'yes' => __('Yes', 'zc-woo-pricely'),
        ),
        'width' => '400px',
    );

    return $in_fields;
}

//=============================
//Volume Metrics Table Repeater
//=============================

add_filter('reon/get-repeater-field-metrics_tables-templates', 'zc_pri_get_volume_metrics_tables_template', 10, 2);

function zc_pri_get_volume_metrics_tables_template($in_templates, $args) {

    if ($args['screen'] == 'option-page' && $args['option_name'] == 'zc_pri') {

        $in_templates[] = array(
            'id' => 'default',
            'head' => array(
                'title' => '',
                'title_field' => 'title',
                'defaut_title' => __('Volume Pricing', 'zc-woo-pricely'),
            )
        );

        $in_templates[] = array(
            'id' => 'group',
            'head' => array(
                'title' => '',
                'title_field' => 'title',
                'defaut_title' => __('Volume Pricing', 'zc-woo-pricely'),
            )
        );
    }

    return $in_templates;
}

add_filter('roen/get-repeater-template-metrics_tables-default-fields', 'zc_pri_get_volume_metrics_tables_template_fields', 10, 2);
add_filter('roen/get-repeater-template-metrics_tables-group-fields', 'zc_pri_get_volume_metrics_tables_template_fields', 10, 2);

function zc_pri_get_volume_metrics_tables_template_fields($in_fields, $args) {
    $in_fields[] = array(
        'id' => 'table_title',
        'type' => 'group-field',
        'title' => __('Table Title', 'zc-woo-pricely'),
        'desc' => __('Controls metrics table title', 'zc-woo-pricely'),
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'enable',
                'type' => 'select2',
                'label' => array(
                    'title' => __('Show:', 'zc-woo-pricely'),
                ),
                'default' => 'yes',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'width' => '90px',
            ),
            array(
                'id' => 'title',
                'type' => 'textbox',
                'label' => array(
                    'title' => __('Text:', 'zc-woo-pricely'),
                ),
                'default' => 'Volume Pricing',
                'placeholder' => __('Table title', 'zc-woo-pricely'),
                'width' => '197px',
            ),
        ),
    );


    $in_fields[] = array(
        'id' => 'quatity_row',
        'type' => 'group-field',
        'title' => __('Quantity Row', 'zc-woo-pricely'),
        'desc' => __('Controls metrics table quantity row', 'zc-woo-pricely'),
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'enable',
                'type' => 'select2',
                'label' => array(
                    'title' => __('Show:', 'zc-woo-pricely'),
                ),
                'default' => 'yes',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'width' => '90px',
            ),
            array(
                'id' => 'label',
                'type' => 'textbox',
                'label' => array(
                    'title' => __('Row Label:', 'zc-woo-pricely'),
                ),
                'default' => 'Qty',
                'placeholder' => __('Quantity row label', 'zc-woo-pricely'),
                'width' => '162px',
            ),
        ),
    );


    $in_fields[] = array(
        'id' => 'price_row',
        'type' => 'group-field',
        'title' => __('Price Row', 'zc-woo-pricely'),
        'desc' => __('Controls metrics table price row', 'zc-woo-pricely'),
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'enable',
                'type' => 'select2',
                'label' => array(
                    'title' => __('Show:', 'zc-woo-pricely'),
                ),
                'default' => 'yes',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'width' => '90px',
            ),
            array(
                'id' => 'label',
                'type' => 'textbox',
                'label' => array(
                    'title' => __('Row Label:', 'zc-woo-pricely'),
                ),
                'default' => 'Price',
                'placeholder' => __('Price row label', 'zc-woo-pricely'),
                'width' => '162px',
            ),
        ),
    );


    $in_fields[] = array(
        'id' => 'price_per_row',
        'type' => 'group-field',
        'title' => __('Price Percent Row', 'zc-woo-pricely'),
        'desc' => __('Controls metrics table price row', 'zc-woo-pricely'),
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'enable',
                'type' => 'select2',
                'label' => array(
                    'title' => __('Show:', 'zc-woo-pricely'),
                ),
                'default' => 'no',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'width' => '90px',
            ),
            array(
                'id' => 'label',
                'type' => 'textbox',
                'label' => array(
                    'title' => __('Row Label:', 'zc-woo-pricely'),
                ),
                'default' => 'Price (%)',
                'placeholder' => __('Price (%) row label', 'zc-woo-pricely'),
                'width' => '162px',
            ),
        ),
    );

    $in_fields[] = array(
        'id' => 'discount_row',
        'type' => 'group-field',
        'title' => __('Discount Row', 'zc-woo-pricely'),
        'desc' => __('Controls metrics table discount amount row', 'zc-woo-pricely'),
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'enable',
                'type' => 'select2',
                'label' => array(
                    'title' => __('Show:', 'zc-woo-pricely'),
                ),
                'default' => 'yes',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'width' => '90px',
            ),
            array(
                'id' => 'label',
                'type' => 'textbox',
                'label' => array(
                    'title' => __('Row Label:', 'zc-woo-pricely'),
                ),
                'default' => 'Discount',
                'placeholder' => __('Discount row label', 'zc-woo-pricely'),
                'width' => '162px',
            ),
        ),
    );

    $in_fields[] = array(
        'id' => 'discount_per_row',
        'type' => 'group-field',
        'title' => __('Discount Percent Row', 'zc-woo-pricely'),
        'desc' => __('Controls metrics table discount percentage row', 'zc-woo-pricely'),
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'enable',
                'type' => 'select2',
                'label' => array(
                    'title' => __('Show:', 'zc-woo-pricely'),
                ),
                'default' => 'no',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'width' => '90px',
            ),
            array(
                'id' => 'label',
                'type' => 'textbox',
                'label' => array(
                    'title' => __('Row Label:', 'zc-woo-pricely'),
                ),
                'default' => 'Discount (%)',
                'placeholder' => __('Discount (%) row label', 'zc-woo-pricely'),
                'width' => '162px',
            ),
        ),
    );

    $in_fields[] = array(
        'id' => 'show_missed_ranges',
        'type' => 'select2',
        'title' => __('Show Missing Ranges', 'zc-woo-pricely'),
        'desc' => __('Controls missing ranges visibility', 'zc-woo-pricely'),
        'default' => 'yes',
        'options' => array(
            'no' => __('No', 'zc-woo-pricely'),
            'yes' => __('Yes', 'zc-woo-pricely'),
        ),
        'width' => '396px',
    );


    return $in_fields;
}

//============================
//Products Rule Modes Repeater
//============================
add_filter('reon/get-simple-repeater-field-checkout_prices_products_mode-templates', 'zc_pri_get_checkout_prices_products_mode_template', 10, 2);

function zc_pri_get_checkout_prices_products_mode_template($in_templates, $args) {

    if ($args['screen'] == 'option-page' && $args['option_name'] == 'zc_pri') {
        $in_templates[] = array(
            'id' => 'mode',
        );
    }

    return $in_templates;
}

add_filter('roen/get-simple-repeater-template-checkout_prices_products_mode-mode-fields', 'zc_pri_get_checkout_prices_products_mode_template_mode_fields', 10, 2);

function zc_pri_get_checkout_prices_products_mode_template_mode_fields($in_fields, $args) {
    $rule_args = array(
        'section' => 'checkout_prices',
        'panel' => 'conditions',
    );

    $options = array(
        '' => __('All Conditions', 'zc-woo-pricely'),
    );

    foreach (zc_pri_get_condition_list($rule_args) as $key => $value) {
        $options[$key] = $value;
    }

    $in_fields[] = array(
        'id' => 'rule_type',
        'type' => 'select2',
        'default' => 'no',
        'options' => $options,
        'width' => '98%',
        'box_width' => '42%',
    );

    $in_fields[] = array(
        'id' => 'mode',
        'type' => 'select2',
        'default' => 'cart_checkout_product',
        'options' => array(
            'cart_checkout_product' => __('Validate on cart, checkout and products page', 'zc-woo-pricely'),
            'cart_checkout' => __('Validate on cart and checkout page only', 'zc-woo-pricely'),
        ),
        'width' => '100%',
        'box_width' => '58%',
    );


    return $in_fields;
}
