<?php

add_filter('reon/get-option-page-' . $option_name . '-sections', 'dpd_get_config_checkout_fee_section', 40);

function dpd_get_config_checkout_fee_section($in_sections) {
    $in_sections[] = array(
        'title' => __('Checkout Fees', 'zc-woo-pricely'),
        'id' => 'checkout_fees',
//        'group' => 1
    );

    return $in_sections;
}

add_filter('get-option-page-' . $option_name . 'section-checkout_fees-fields', 'zc_get_dpd_config_sections_fees');

function zc_get_dpd_config_sections_fees($in_fields) {

    $in_fields[] = array(
        'id' => 'module_title',
        'type' => 'paneltitle',
        'full_width' => true,
        'center_head' => true,
        'title' => __('Checkout Fee Rules', 'zc-woo-pricely'),
        'desc' => __('Create unlimited number checkout fee rules', 'zc-woo-pricely'),
    );

    $in_fields[] = array(
        'id' => 'checkout_fees',
        'type' => 'panel',
        'last' => true,
        'white_panel' => false,
        'panel_size' => 'smaller',
        'width' => '100%',
        'fields' => array(
            array(
                'id' => 'any_id',
                'type' => 'columns-field',
                'columns' => 8,
                'merge_fields' => false,
                'fields' => array(
                    array(
                        'id' => 'max_fee_type',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Fees Limit', 'zc-woo-pricely'),
                        'tooltip' => __('Controls checkout fees limit', 'zc-woo-pricely'),
                        'default' => 'before_add_to_cart',
                        'options' => array(
                            'no' => __('No limit', 'zc-woo-pricely'),
                            'amount' => __('Fee amount', 'zc-woo-pricely'),
                            'per' => __('Percentage Fee', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                        'fold_id' => 'max_fee_type',
                    ),
                    array(
                        'id' => 'max_fee_amount',
                        'type' => 'textbox',
                        'input_type' => 'number',
                        'column_size' => 1,
                        'column_title' => __('Limit', 'zc-woo-pricely'),
                        'tooltip' => __('Controls fees limit amount', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('0.00', 'zc-woo-pricely'),
                        'width' => '100%',
                        'attributes' => array(
                            'min' => '0',
                            'step' => '1',
                        ),
                        'fold' => array(
                            'target' => 'max_fee_type',
                            'attribute' => 'value',
                            'value' => 'no',
                            'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => true,
                        ),
                    ),
                    array(
                        'id' => 'base_on',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Limit Based On', 'zc-woo-pricely'),
                        'tooltip' => __('Controls checkout percentage fees limit based on cart totals', 'zc-woo-pricely'),
                        'default' => 'yes',
                        'options' => array(
                            'subtotal' => __('Subtotal including tax', 'zc-woo-pricely'),
                            'subtotal_ex_tax' => __('Subtotal excluding tax', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                        'fold' => array(
                            'target' => 'max_fee_type',
                            'attribute' => 'value',
                            'value' => 'per',
                            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => true,
                        ),
                    ),
                    array(
                        'id' => 'mode',
                        'type' => 'select2',
                        'column_size' => 3,
                        'column_title' => __('Rules Apply Mode', 'zc-woo-pricely'),
                        'tooltip' => __('Controls checkout fees rules apply mode', 'zc-woo-pricely'),
                        'default' => 'yes',
                        'options' => array(
                            'all' => __('Apply all valid rules', 'zc-woo-pricely'),
                            'bigger' => __('Apply rules/groups with bigger fee', 'zc-woo-pricely'),
                            'smaller' => __('Apply rules/groups with smaller fee', 'zc-woo-pricely'),
                            'first' => __('Apply first valid rule/group', 'zc-woo-pricely'),
                            'last' => __('Apply last valid rule/group', 'zc-woo-pricely'),
                            'no' => __('Do not apply any rule', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                ),
            ),
        ),
    );

    $in_fields[] = array(
        'id' => 'checkout_fees_rules',
        'type' => 'repeater',
        'white_repeater' => false,
        'repeater_size' => 'small',
        'accordions' => true,
        'buttons_sep' => false,
        'delete_button' => true,
        'clone_button' => true,
        'width' => '100%',
        'auto_expand' => array(
            'new_section' => true,
            'cloned_section' => true,
        ),
        'sortable' => array(
            'enabled' => true,
        ),
        'template_adder' => array(
            'position' => 'right',
            'show_list' => false,
            'button_text' => __('Add Fee Rule', 'zc-woo-pricely'),
        ),
    );


    return $in_fields;
}

//===================
//Fee Groups DataList
//===================

add_filter('reon/get-data-list', 'zc_pri_get_fee_group_data_list', 10, 2);

function zc_pri_get_fee_group_data_list($result, $data_args) {
    global $zc_pri;
    if ($data_args['source'] == 'dpd:fee_groups') {
        if (isset($zc_pri['fee_groups'])) {
            $cnt = 0;
            foreach ($zc_pri['fee_groups'] as $group) {
                $result['group_' . $cnt] = $group['title'];
                $cnt++;
            }
        }
        if (count($result) == 0) {
            $result['group_0'] = __('Grouped Fees', 'zc-woo-pricely');
        }
    }

    return $result;
}
