<?php

add_filter('zcpri/get-product-rule-type-group-product_properties', 'zc_pri_get_product_rule_type_weight', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_weight')) {

    function zc_pri_get_product_rule_type_weight($list = array(), $args) {
        $weight_text = str_replace('[0]', get_option('woocommerce_weight_unit'), __('Product Weight ([0])', 'zc-woo-pricely'));
        $list['weight'] = $weight_text;
        return $list;
    }

}



add_filter('zcpri/get-product-rule-type-fields', 'zc_pri_get_product_rule_type_product_weight_fields', 10, 2);

if (!function_exists('zc_pri_get_product_rule_type_product_weight_fields')) {

    function zc_pri_get_product_rule_type_product_weight_fields($fields, $args) {

        $fld = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    'empty' => __('Empty', 'zc-woo-pricely'),
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'fold_id' => 'weight_compare',
                'width' => '99%',
                'box_width' => '44%',
            ),
            array(
                'id' => 'weight',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0.00',
                'placeholder' => __('0.00', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '37%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '0.01',
                ),
                'fold' => array(
                    'target' => 'weight_compare',
                    'attribute' => 'value',
                    'value' => 'empty',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
            ),
            array(
                'id' => 'yes_no',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'weight_compare',
                    'attribute' => 'value',
                    'value' => 'empty',
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'width' => '100%',
                'box_width' => '37%',
            ),
        );


        $fields['weight'] = $fld;
        return $fields;
    }

}


add_filter('zcpri/validate-product-filter-weight', 'zc_pri_validate_product_filter_weight', 10, 3);
if (!function_exists('zc_pri_validate_product_filter_weight')) {

    function zc_pri_validate_product_filter_weight($product, $rule, $args) {

        $yes_no = 'no';
        $rule_value = '';
        if (isset($rule['yes_no'])) {
            $yes_no = $rule['yes_no'];
        }
        if (isset($rule['weight'])) {
            $rule_value = $rule['weight'];
        }




        $weight = wc_get_product($product['id'])->get_weight(false);
        if ($weight != '') {
            $weight = (float) $weight;
        }

        return WooPricely_Validation_Util::validate_value($rule['compare'], $weight, $rule_value, $yes_no);
    }

}