<?php

add_filter('zcpri/get-product-rule-type-group-product_properties', 'zc_pri_get_product_rule_type_product_sale_total', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_product_sale_total')) {

    function zc_pri_get_product_rule_type_product_sale_total($list = array(), $args) {
        $list['total_sold'] = __('Product Total Sold', 'zc-woo-pricely');
        return $list;
    }

}



add_filter('zcpri/get-product-rule-type-fields', 'zc_pri_get_product_rule_type_product_total_sold_fields', 10, 2);

if (!function_exists('zc_pri_get_product_rule_type_product_total_sold_fields')) {

    function zc_pri_get_product_rule_type_product_total_sold_fields($fields, $args) {

        $fld = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'width' => '99%',
                'box_width' => '44%',
            ),
            array(
                'id' => 'total_sold',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '37%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
        );


        $fields['total_sold'] = $fld;
        return $fields;
    }

}


add_filter('zcpri/validate-product-filter-total_sold', 'zc_pri_validate_product_filter_total_sold', 10, 3);
if (!function_exists('zc_pri_validate_product_filter_total_sold')) {

    function zc_pri_validate_product_filter_total_sold($product, $rule, $args) {
        $total_sales = wc_get_product($product['id'])->get_total_sales(false);
        if ($total_sales == '') {
            $total_sales = 0;
        }
        return WooPricely_Validation_Util::validate_value($rule['compare'], $total_sales, $rule['total_sold'], 'no');
    }

}