<?php

add_filter('zcpri/get-product-rule-type-group-product_properties', 'zc_pri_get_product_rule_type_stock_quantity', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_stock_quantity')) {

    function zc_pri_get_product_rule_type_stock_quantity($list = array(), $args) {
        $list['stock_quantity'] = __('Product Stock Quantity', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-product-rule-type-fields', 'zc_pri_get_product_rule_type_product_stock_quantity_fields', 10, 2);

if (!function_exists('zc_pri_get_product_rule_type_product_stock_quantity_fields')) {

    function zc_pri_get_product_rule_type_product_stock_quantity_fields($fields, $args) {

        $fld = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    'empty' => __('Empty', 'zc-woo-pricely'),
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'fold_id' => 'stock_compare',
                'width' => '99%',
                'box_width' => '44%',
            ),
            array(
                'id' => 'stock_qty',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '37%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
                'fold' => array(
                    'target' => 'stock_compare',
                    'attribute' => 'value',
                    'value' => 'empty',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
            ),
            array(
                'id' => 'yes_no',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'stock_compare',
                    'attribute' => 'value',
                    'value' => 'empty',
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'width' => '100%',
                'box_width' => '37%',
            ),
        );


        $fields['stock_quantity'] = $fld;
        return $fields;
    }

}

add_filter('zcpri/validate-product-filter-stock_quantity', 'zc_pri_validate_product_filter_stock_quantity', 10, 3);
if (!function_exists('zc_pri_validate_product_filter_stock_quantity')) {

    function zc_pri_validate_product_filter_stock_quantity($product, $rule, $args) {
        $yes_no = 'no';
        $rule_value = '';
        if (isset($rule['yes_no'])) {
            $yes_no = $rule['yes_no'];
        }
        if (isset($rule['stock_qty'])) {
            $rule_value = $rule['stock_qty'];
        }


        $stock_quantity = wc_get_product($product['id'])->get_stock_quantity(false);
        return WooPricely_Validation_Util::validate_value($rule['compare'], $stock_quantity, $rule_value, $yes_no);
    }

}