<?php

add_filter('zcpri/get-product-rule-type-group-product_properties', 'zc_pri_get_product_rule_type_product_on_sale', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_product_on_sale')) {

    function zc_pri_get_product_rule_type_product_on_sale($list = array(), $args) {
        $list['on_sale'] = __('Product Is On Sale', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-product-rule-type-fields', 'zc_pri_get_product_rule_type_on_sale_fields', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_on_sale_fields')) {

    function zc_pri_get_product_rule_type_on_sale_fields($fields, $args) {

        $fields['on_sale'] = array(
            array(
                'id' => 'is_on_sale',
                'type' => 'select2',
                'default' => 'no',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'width' => '100%',
                'box_width' => '81%',
            )
        );
        return $fields;
    }

}


add_filter('zcpri/validate-product-filter-on_sale', 'zc_pri_validate_product_filter_on_sale', 10, 3);
if (!function_exists('zc_pri_validate_product_filter_on_sale')) {

    function zc_pri_validate_product_filter_on_sale($product, $rule, $args) {
        $is_on_sale = wc_get_product($product['id'])->is_on_sale(false);
        return WooPricely_Validation_Util::validate_yes_no($is_on_sale, $rule['is_on_sale']);
    }

}