<?php

add_filter('zcpri/get-product-rule-type-group-product_properties', 'zc_pri_get_product_rule_type_product_meta_field', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_product_meta_field')) {

    function zc_pri_get_product_rule_type_product_meta_field($list = array(), $args) {
        $list['meta_field'] = __('Product Meta Field', 'zc-woo-pricely');
        return $list;
    }

}


add_filter('zcpri/get-product-rule-type-fields', 'zc_pri_get_product_rule_type_product_meta_field_fields', 10, 2);

if (!function_exists('zc_pri_get_product_rule_type_product_meta_field_fields')) {

    function zc_pri_get_product_rule_type_product_meta_field_fields($fields, $args) {

        $fld = array(
            array(
                'id' => 'meta_key',
                'type' => 'textbox',
                'input_type' => 'text',
                'default' => '',
                'placeholder' => __('Meta field key', 'zc-woo-pricely'),
                'width' => '98%',
                'box_width' => '33%',
            ),
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'empty',
                'options' => array(
                    'empty' => __('Empty', 'zc-woo-pricely'),
                    'contains' => __('Contains', 'zc-woo-pricely'),
                    'not_contains' => __('Not contains', 'zc-woo-pricely'),
                    'begins' => __('Begins with', 'zc-woo-pricely'),
                    'ends' => __('Ends with', 'zc-woo-pricely'),
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                    'checked' => __('Checked', 'zc-woo-pricely'),
                ),
                'fold_id' => 'meta_field_compare',
                'width' => '98%',
                'box_width' => '31%',
            ),
            array(
                'id' => 'meta_value',
                'type' => 'textbox',
                'input_type' => 'text',
                'default' => '',
                'placeholder' => __('Value', 'zc-woo-pricely'),
                'fold' => array(
                    'target' => 'meta_field_compare',
                    'attribute' => 'value',
                    'value' => array('contains', 'not_contains', 'begins', 'ends', '>=', '>', '<=', '<', '==', '!='),
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'width' => '100%',
                'box_width' => '17%',
            ),
            array(
                'id' => 'yes_no',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'meta_field_compare',
                    'attribute' => 'value',
                    'value' => array('empty', 'checked'),
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'width' => '100%',
                'box_width' => '17%',
            ),
        );


        $fields['meta_field'] = $fld;
        return $fields;
    }

}


add_filter('zcpri/validate-product-filter-meta_field', 'zc_pri_validate_product_filter_meta_field', 10, 3);
if (!function_exists('zc_pri_validate_product_filter_meta_field')) {

    function zc_pri_validate_product_filter_meta_field($product, $rule, $args) {
        $yes_no = 'no';
        $rule_value = '';
        if (isset($rule['yes_no'])) {
            $yes_no = $rule['yes_no'];
        }
        if (isset($rule['meta_value'])) {
            $rule_value = $rule['meta_value'];
        }

        $meta_value = get_post_meta($product['id'], $rule['meta_key'], true);

        return WooPricely_Validation_Util::validate_value($rule['compare'], $meta_value, $rule_value, $yes_no);
    }

}