<?php

add_filter('zcpri/get-product-rule-type-group-product_properties', 'zc_pri_get_product_rule_type_is_virtual', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_is_virtual')) {

    function zc_pri_get_product_rule_type_is_virtual($list = array(), $args) {
        $list['is_virtual'] = __('Virtual Product', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-product-rule-type-fields', 'zc_pri_get_product_rule_type_is_virtual_fields', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_is_virtual_fields')) {

    function zc_pri_get_product_rule_type_is_virtual_fields($fields, $args) {

        $fields['is_virtual'] = array(
            array(
                'id' => 'is_virtual',
                'type' => 'select2',
                'default' => 'no',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                 'width' => '100%',
                'box_width' => '81%',
            )
        );
        return $fields;
    }

}

add_filter('zcpri/validate-product-filter-is_virtual', 'zc_pri_validate_product_filter__is_virtual', 10, 3);
if (!function_exists('zc_pri_validate_product_filter__is_virtual')) {

    function zc_pri_validate_product_filter__is_virtual($product, $rule, $args) {
        $is_virtual = wc_get_product($product['id'])->is_virtual();
        return WooPricely_Validation_Util::validate_yes_no($is_virtual, $rule['is_virtual']);
    }

}