<?php

add_filter('zcpri/get-product-rule-type-group-product_properties', 'zc_pri_get_product_rule_type_is_featured', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_is_featured')) {

    function zc_pri_get_product_rule_type_is_featured($list = array(), $args) {
        $list['is_featured'] = __('Featured Product', 'zc-woo-pricely');
        return $list;
    }

}


add_filter('zcpri/get-product-rule-type-fields', 'zc_pri_get_product_rule_type_is_featured_fields', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_is_featured_fields')) {

    function zc_pri_get_product_rule_type_is_featured_fields($fields, $args) {

        $fields['is_featured'] = array(
            array(
                'id' => 'is_featured',
                'type' => 'select2',
                'default' => 'no',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'width' => '100%',
                'box_width' => '81%',
            )
        );
        return $fields;
    }

}


add_filter('zcpri/validate-product-filter-is_featured', 'zc_pri_validate_product_filter_is_featured', 10, 3);
if (!function_exists('zc_pri_validate_product_filter_is_featured')) {

    function zc_pri_validate_product_filter_is_featured($product, $rule, $args) {
        $is_featured = wc_get_product($product['id'])->is_featured();
        return WooPricely_Validation_Util::validate_yes_no($is_featured, $rule['is_featured']);
    }

}