<?php

add_filter('zcpri/get-product-rule-type-group-product_properties', 'zc_pri_get_product_rule_type_is_downloadable', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_is_downloadable')) {

    function zc_pri_get_product_rule_type_is_downloadable($list = array(), $args) {
        $list['is_downloadable'] = __('Downloadable Product', 'zc-woo-pricely');
        return $list;
    }

}


add_filter('zcpri/get-product-rule-type-fields', 'zc_pri_get_product_rule_type_is_downloadable_fields', 10, 2);
if (!function_exists('zc_pri_get_product_rule_type_is_downloadable_fields')) {

    function zc_pri_get_product_rule_type_is_downloadable_fields($fields, $args) {

        $fields['is_downloadable'] = array(
            array(
                'id' => 'is_downloadable',
                'type' => 'select2',
                'default' => 'no',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'width' => '100%',
                'box_width' => '81%',
            )
        );
        return $fields;
    }

}


add_filter('zcpri/validate-product-filter-is_downloadable', 'zc_pri_validate_product_filter_is_downloadable', 10, 3);
if (!function_exists('zc_pri_validate_product_filter_is_downloadable')) {

    function zc_pri_validate_product_filter_is_downloadable($product, $rule, $args) {
        $is_downloadable = wc_get_product($product['id'])->is_downloadable();
        return WooPricely_Validation_Util::validate_yes_no($is_downloadable, $rule['is_downloadable']);
    }

}
