<?php

add_filter('zcpri/get-condition-type-group-customer', 'zc_pri_get_condition_type_user_roles', 10, 2);
if (!function_exists('zc_pri_get_condition_type_user_roles')) {

    function zc_pri_get_condition_type_user_roles($list = array(), $args) {
        $list['user_roles'] = __('User Roles', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_user_roles_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_user_roles_fields')) {

    function zc_pri_get_condition_type_user_roles_fields($fields, $args) {

        $fields['user_roles'] = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'in_all_list' => __('All in the list', 'zc-woo-pricely'),
                    'in_list_only' => __('Only in the list', 'zc-woo-pricely'),
                    'in_all_list_only' => __('Only all in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'user_roles',
                'type' => 'select2',
                'multiple' => true,
                'placeholder' => 'Roles...',
                'allow_clear' => true,
                'data' => 'roles',
                'width' => '100%',
                'box_width' => '56%',
            )
        );
        return $fields;
    }

}

add_filter('zcpri/validate-condition-user_roles', 'zc_pri_validate_condition_user_roles', 10, 3);
if (!function_exists('zc_pri_validate_condition_user_roles')) {

    function zc_pri_validate_condition_user_roles($rule, $args) {

        if (!is_array($rule['user_roles'])) {
            return false;
        }

        $user_roles = wp_get_current_user()->roles;
        return WooPricely_Validation_Util::validate_list_list($user_roles, $rule['user_roles'], $rule['compare']);
    }

}