<?php

add_filter('zcpri/get-condition-type-group-customer', 'zc_pri_get_condition_type_customer_users', 10, 2);
if (!function_exists('zc_pri_get_condition_type_customer_users')) {

    function zc_pri_get_condition_type_customer_users($list = array(), $args) {

        $list['user_customers'] = __('Customers', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_user_customers_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_user_customers_fields')) {

    function zc_pri_get_condition_type_user_customers_fields($fields, $args) {

        $fields['user_customers'] = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'user_emails',
                'type' => 'select2',
                'multiple' => true,
                'minimum_input_length' => 2,
                'placeholder' => 'Search users...',
                'allow_clear' => true,
                'minimum_results_forsearch' => 10,
                'data' => array(
                    'source' => 'users',
                    'ajax' => true,
                    'value_col' => 'email',
                    'show_value' => true,
                ),
                'width' => '100%',
                'box_width' => '56%',
            )
        );
        return $fields;
    }

}

add_filter('zcpri/validate-condition-user_customers', 'zc_pri_validate_condition_user_customers', 10, 3);
if (!function_exists('zc_pri_validate_condition_user_customers')) {

    function zc_pri_validate_condition_user_customers($rule, $args) {

        if (!is_array($rule['user_emails'])) {
            return false;
        }


        $customer_email = wp_get_current_user()->user_email;
        if ($customer_email == '') {
            return false;
        }
        return WooPricely_Validation_Util::validate_value_list($customer_email, $rule['user_emails'], $rule['compare']);
    }

}