<?php

add_filter('zcpri/get-condition-type-group-customer', 'zc_pri_get_condition_type_user_caps', 10, 2);
if (!function_exists('zc_pri_get_condition_type_user_caps')) {

    function zc_pri_get_condition_type_user_caps($list = array(), $args) {
        
        $list['user_caps'] =__('User Capabilities', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_user_caps_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_user_caps_fields')) {

    function zc_pri_get_condition_type_user_caps_fields($fields, $args) {

        $fields['user_caps'] = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'in_all_list' => __('All in the list', 'zc-woo-pricely'),
                    'in_list_only' => __('Only in the list', 'zc-woo-pricely'),
                    'in_all_list_only' => __('Only all in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'user_caps',
                'type' => 'select2',
                'multiple' => true,
                'placeholder' => 'Roles...',
                'allow_clear' => true,
                'data' => 'wp_caps',
                'minimum_input_length' => 1,
                'placeholder' => 'Search capabilities...',
                'data' => array(
                    'source' => 'wp_caps',
                    'ajax' => true,
                ),
                'width' => '100%',
                'box_width' => '56%',
            )
        );
        return $fields;
    }

}

add_filter('zcpri/validate-condition-user_caps', 'zc_pri_validate_condition_user_caps', 10, 3);
if (!function_exists('zc_pri_validate_condition_user_caps')) {

    function zc_pri_validate_condition_user_caps($rule, $args) {

        if (!is_array($rule['user_caps'])) {
            return false;
        }

        $user_caps =array();
        foreach (wp_get_current_user()->allcaps as $key => $user_cap) {
            if($user_cap==true){
                $user_caps[]=$key;
            }
        }
        return WooPricely_Validation_Util::validate_list_list($user_caps, $rule['user_caps'], $rule['compare']);
    }

}