<?php

add_filter('zcpri/get-condition-type-group-billing_shipping', 'zc_pri_get_condition_type_shipping_zone', 10, 2);
if (!function_exists('zc_pri_get_condition_type_shipping_zone')) {

    function zc_pri_get_condition_type_shipping_zone($list = array(), $args) {
        $list['shipping_zone'] = __('Shipping Zone', 'zc-woo-pricely');
        return $list;
    }

}


add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_shipping_zone_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_shipping_zone_fields')) {

    function zc_pri_get_condition_type_shipping_zone_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'shipping_zones',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'placeholder' => __('Shipping zones...', 'zc-woo-pricely'),
                'data' => 'wc:shipping_zones',
                'width' => '100%',
                'box_width' => '56%',
            )
        );

        $fields['shipping_zone'] = $flds;
        return $fields;
    }

}


add_filter('zcpri/validate-condition-shipping_zone', 'zc_pri_validate_condition_shipping_zone', 10, 3);
if (!function_exists('zc_pri_validate_condition_shipping_zone')) {

    function zc_pri_validate_condition_shipping_zone($rule, $args) {
        if (!is_array($rule['shipping_zones'])) {
            return false;
        }

        $zone_id = WooPricelyUtil::get_chosen_shipping_zone();
        if ($zone_id == 0) {
            return false;
        }
        return WooPricely_Validation_Util::validate_value_list($zone_id, $rule['shipping_zones'], $rule['compare']);
    }

}


