<?php

add_filter('zcpri/get-condition-type-group-billing_shipping', 'zc_pri_get_condition_type_shipping_rate', 10, 2);
if (!function_exists('zc_pri_get_condition_type_shipping_rate')) {

    function zc_pri_get_condition_type_shipping_rate($list = array(), $args) {
        $list['shipping_rate'] = __('Shipping Rate', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_shipping_rate_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_shipping_rate_fields')) {

    function zc_pri_get_condition_type_shipping_rate_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'shipping_rates',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'placeholder' => __('Shipping rates...', 'zc-woo-pricely'),
                'data' => 'wc:zones_shipping',
                'width' => '100%',
                'box_width' => '56%',
            )
        );

        $fields['shipping_rate'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-shipping_rate', 'zc_pri_validate_condition_shipping_rate', 10, 3);
if (!function_exists('zc_pri_validate_condition_shipping_rate')) {

    function zc_pri_validate_condition_shipping_rate($rule, $args) {
        if (!is_array($rule['shipping_rates'])) {
            return false;
        }
        $chosen_rate = WooPricelyUtil::get_chosen_shipping_rate();
        if ($chosen_rate == 0) {
            return false;
        }
        return WooPricely_Validation_Util::validate_value_list($chosen_rate, $rule['shipping_rates'], $rule['compare']);
    }

}



