<?php

add_filter('zcpri/get-condition-type-group-billing_shipping', 'zc_pri_get_condition_type_shipping_method', 10, 2);
if (!function_exists('zc_pri_get_condition_type_shipping_method')) {

    function zc_pri_get_condition_type_shipping_method($list = array(), $args) {
        $list['shipping_method'] = __('Shipping Method', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_shipping_method_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_shipping_method_fields')) {

    function zc_pri_get_condition_type_shipping_method_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
               'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'shipping_methods',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'placeholder' => __('Shipping methods...', 'zc-woo-pricely'),
                'data' => 'wc:shipping_methods',
                'width' => '100%',
                'box_width' => '56%',
            )
        );

        $fields['shipping_method'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-shipping_method', 'zc_pri_validate_condition_shipping_method', 10, 3);
if (!function_exists('zc_pri_validate_condition_shipping_method')) {

    function zc_pri_validate_condition_shipping_method($rule, $args) {
        if (!is_array($rule['shipping_methods'])) {
            return false;
        }
        $chosen_method = WooPricelyUtil::get_chosen_shipping_method();
        if ($chosen_method == '') {
            return false;
        }
 
        return WooPricely_Validation_Util::validate_value_list($chosen_method, $rule['shipping_methods'], $rule['compare']);
    }

}