<?php

add_filter('zcpri/get-condition-type-group-billing_shipping', 'zc_pri_get_condition_type_shipping_country', 10, 2);
if (!function_exists('zc_pri_get_condition_type_shipping_country')) {

    function zc_pri_get_condition_type_shipping_country($list = array(), $args) {
        $list['shipping_country'] = __('Shipping Country', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_shipping_country_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_shipping_country_fields')) {

    function zc_pri_get_condition_type_shipping_country_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'shipping_countries',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'minimum_input_length' => 2,
                'minimum_results_forsearch' => 10,
                'placeholder' => __('Shipping Countries...', 'zc-woo-pricely'),
                'ajax_data' => 'wc:countries',
                'width' => '100%',
                'box_width' => '56%',
            )
        );

        $fields['shipping_country'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-shipping_country', 'zc_pri_validate_condition_shipping_country', 10, 3);
if (!function_exists('zc_pri_validate_condition_shipping_country')) {

    function zc_pri_validate_condition_shipping_country($rule, $args) {
        if (!is_array($rule['shipping_countries'])) {
            return false;
        }
        $shipping_country = WC()->customer->get_shipping_country(false);
        return WooPricely_Validation_Util::validate_value_list($shipping_country, $rule['shipping_countries'], $rule['compare']);
    }

}