<?php

add_filter('zcpri/get-condition-type-group-billing_shipping', 'zc_pri_get_condition_type_shipping_cost', 10, 2);
if (!function_exists('zc_pri_get_condition_type_shipping_cost')) {

    function zc_pri_get_condition_type_shipping_cost($list = array(), $args) {
        $list['shipping_cost'] = __('Shipping Cost', 'zc-woo-pricely');
        return $list;
    }

}


add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_shipping_cost_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_shipping_cost_fields')) {

    function zc_pri_get_condition_type_shipping_cost_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'width' => '99%',
                'box_width' => '44%',
            ),
            array(
                'id' => 'shipping_cost',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0.00',
                'placeholder' => __('0.00', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '37%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '0.01',
                ),
            )
        );

        $fields['shipping_cost'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-shipping_cost', 'zc_pri_validate_condition_shipping_cost', 10, 3);
if (!function_exists('zc_pri_validate_condition_shipping_cost')) {

    function zc_pri_validate_condition_shipping_cost($rule, $args) {
        if ($rule['shipping_cost'] == '') {
            return false;
        }
        WC()->cart->calculate_shipping();
        $billing_cost = WooPricelyUtil::get_chosen_shipping_method_cost();
        return WooPricely_Validation_Util::validate_value($rule['compare'], $billing_cost, $rule['shipping_cost'], 'no');
    }

}
