<?php

add_filter('zcpri/get-condition-type-group-purchased_history_value', 'zc_pri_get_condition_type_purchased_subtotal_exc_tax_variations', 10, 2);
if (!function_exists('zc_pri_get_condition_type_purchased_subtotal_exc_tax_variations')) {

    function zc_pri_get_condition_type_purchased_subtotal_exc_tax_variations($list = array(), $args) {
        $list['purchased_subtotal_exc_tax_variations'] = __('Bought Variations Value', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_purchased_subtotal_exc_tax_variations_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_purchased_subtotal_exc_tax_variations_fields')) {

    function zc_pri_get_condition_type_purchased_subtotal_exc_tax_variations_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'variation_ids',
                'type' => 'select2',
                'multiple' => true,
                'minimum_input_length' => 2,
                'placeholder' => 'Search variations...',
                'allow_clear' => true,
                'minimum_results_forsearch' => 10,
                'data' => array(
                    'source' => 'wc:product_variations',
                    'ajax' => true,
                    'value_col' => 'id',
                    'value_col_pre' => '#',
                    'show_value' => true,
                ),
                'width' => '98%',
                'box_width' => '35%',
            ),
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '31%',
            ),
            array(
                'id' => 'subtotal_exc_tax',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0.00',
                'placeholder' => __('0.00', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '15%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '0.01',
                ),
            ),
        );

        $fields['purchased_subtotal_exc_tax_variations'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-purchased_subtotal_exc_tax_variations', 'zc_pri_validate_condition_purchased_subtotal_exc_tax_variations', 10, 3);
if (!function_exists('zc_pri_validate_condition_purchased_subtotal_exc_tax_variations')) {

    function zc_pri_validate_condition_purchased_subtotal_exc_tax_variations($rule, $args) {

        if (!is_array($rule['variation_ids'])) {
            return false;
        }

        $subtotal = WooPricelyUtil::get_purchase_history_subtotal(get_current_user_id(), 'variation_ids', $rule['variation_ids'], '', true, true);
        print_r($subtotal);
        return WooPricely_Validation_Util::validate_value($rule['compare'], $subtotal, $rule['subtotal_exc_tax'], 'no');
    }

}