<?php

add_filter('zcpri/get-condition-type-group-purchased_history_value', 'zc_pri_get_condition_type_purchased_subtotal_exc_tax_categories', 10, 2);
if (!function_exists('zc_pri_get_condition_type_purchased_subtotal_exc_tax_categories')) {

    function zc_pri_get_condition_type_purchased_subtotal_exc_tax_categories($list = array(), $args) {
        $list['purchased_subtotal_exc_tax_categories'] = __('Bought Categories Value', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_purchased_subtotal_exc_tax_categories_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_purchased_subtotal_exc_tax_categories_fields')) {

    function zc_pri_get_condition_type_purchased_subtotal_exc_tax_categories_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'category_ids',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'placeholder' => 'Product categories...',
                'data' => 'categories:product_cat',
                'width' => '98%',
                'box_width' => '35%',
            ),
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '31%',
            ),
            array(
                'id' => 'subtotal_exc_tax',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0.00',
                'placeholder' => __('0.00', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '15%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '0.01',
                ),
            ),
        );

        $fields['purchased_subtotal_exc_tax_categories'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-purchased_subtotal_exc_tax_categories', 'zc_pri_validate_condition_purchased_subtotal_exc_tax_categories', 10, 3);
if (!function_exists('zc_pri_validate_condition_purchased_subtotal_exc_tax_categories')) {

    function zc_pri_validate_condition_purchased_subtotal_exc_tax_categories($rule, $args) {

        if (!is_array($rule['category_ids'])) {
            return false;
        }

        $subtotal = WooPricelyUtil::get_purchase_history_subtotal(get_current_user_id(), 'category_ids', $rule['category_ids'], '', true, true);

        return WooPricely_Validation_Util::validate_value($rule['compare'], $subtotal, $rule['subtotal_exc_tax'], 'no');
    }

}