<?php

add_filter('zcpri/get-condition-type-group-purchased_history_qty', 'zc_pri_get_condition_type_purchased_qty_products', 10, 2);
if (!function_exists('zc_pri_get_condition_type_purchased_qty_products')) {

    function zc_pri_get_condition_type_purchased_qty_products($list = array(), $args) {
        $list['purchased_qty_products'] = __('Bought Products Quantity', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_purchased_qty_products_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_purchased_qty_products_fields')) {

    function zc_pri_get_condition_type_purchased_qty_products_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'product_ids',
                'type' => 'select2',
                'multiple' => true,
                'minimum_input_length' => 2,
                'placeholder' => 'Search products...',
                'allow_clear' => true,
                'minimum_results_forsearch' => 10,
                'data' => array(
                    'source' => 'wc:products',
                    'ajax' => true,
                    'value_col' => 'id',
                    'value_col_pre' => '#',
                    'show_value' => true,
                ),
                'width' => '98%',
                'box_width' => '35%',
            ),
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '31%',
            ),
            array(
                'id' => 'quantity',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '15%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
        );

        $fields['purchased_qty_products'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-purchased_qty_products', 'zc_pri_validate_condition_purchased_qty_products', 10, 3);
if (!function_exists('zc_pri_validate_condition_purchased_qty_products')) {

    function zc_pri_validate_condition_purchased_qty_products($rule, $args) {

        if (!is_array($rule['product_ids'])) {
            return false;
        }

        $quantity = WooPricelyUtil::get_purchase_history_quantity(get_current_user_id(), 'product_ids', $rule['product_ids'], '', true, true);

        return WooPricely_Validation_Util::validate_value($rule['compare'], $quantity, $rule['quantity'], 'no');
    }

}