<?php

add_filter('zcpri/get-condition-type-group-purchased_history_qty', 'zc_pri_get_condition_type_purchased_qty_categories', 10, 2);
if (!function_exists('zc_pri_get_condition_type_purchased_qty_categories')) {

    function zc_pri_get_condition_type_purchased_qty_categories($list = array(), $args) {
        $list['purchased_qty_categories'] = __('Bought Categories Quantity', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_purchased_qty_categories_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_purchased_qty_categories_fields')) {

    function zc_pri_get_condition_type_purchased_qty_categories_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'category_ids',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'placeholder' => 'Product categories...',
                'data' => 'categories:product_cat',
                'width' => '98%',
                'box_width' => '35%',
            ),
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '31%',
            ),
            array(
                'id' => 'quantity',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '15%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
        );

        $fields['purchased_qty_categories'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-purchased_qty_categories', 'zc_pri_validate_condition_purchased_qty_categories', 10, 3);
if (!function_exists('zc_pri_validate_condition_purchased_qty_categories')) {

    function zc_pri_validate_condition_purchased_qty_categories($rule, $args) {

         if (!is_array($rule['category_ids'])) {
            return false;
        }

        $quantity = WooPricelyUtil::get_purchase_history_quantity(get_current_user_id(), 'category_ids', $rule['category_ids'], '', true, true);

        return WooPricely_Validation_Util::validate_value($rule['compare'], $quantity, $rule['quantity'], 'no');
    }

}