<?php

add_filter('zcpri/get-condition-type-group-purchased_history', 'zc_pri_get_condition_type_purchased_categories', 10, 2);
if (!function_exists('zc_pri_get_condition_type_purchased_categories')) {

    function zc_pri_get_condition_type_purchased_categories($list = array(), $args) {
        $list['purchased_categories'] = __('Bought Categories', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_purchased_categories_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_purchased_categories_fields')) {

    function zc_pri_get_condition_type_purchased_categories_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'date_type',
                'type' => 'select2',
                'default' => 'all_time',
                'options' => array(
                    'all_time' => __('All time', 'zc-woo-pricely'),
                    'current' => __('Current', 'zc-woo-pricely'),
                    'hours' => __('Hours', 'zc-woo-pricely'),
                    'days' => __('Days', 'zc-woo-pricely'),
                    'weeks' => __('Weeks', 'zc-woo-pricely'),
                    'months' => __('Months', 'zc-woo-pricely'),
                    'years' => __('Years', 'zc-woo-pricely'),
                ),
                'fold_id' => 'date_type',
                'width' => '98%',
                'box_width' => '16%',
            ),
            array(
                'id' => 'current',
                'type' => 'select2',
                'default' => 'day',
                'options' => array(
                    'day' => __('Day', 'zc-woo-pricely'),
                    'week' => __('Week', 'zc-woo-pricely'),
                    'month' => __('Month', 'zc-woo-pricely'),
                    'year' => __('Year', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => array('current'),
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'width' => '98%',
                'box_width' => '15%',
            ),
            array(
                'id' => 'date_offset',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '1',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '98%',
                'box_width' => '15%',
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => array('hours', 'days', 'weeks', 'months', 'years'),
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    'in_list' => __('Any in list', 'zc-woo-pricely'),
                    'in_all_list' => __('All in list', 'zc-woo-pricely'),
                    'in_list_only' => __('Only in list', 'zc-woo-pricely'),
                    'in_all_list_only' => __('Only all in list', 'zc-woo-pricely'),
                    'none' => __('None in list', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => 'all_time',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'width' => '98%',
                'box_width' => '22%',
            ),
            array(
                'id' => 'all_time_compare',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    'in_list' => __('Any in list', 'zc-woo-pricely'),
                    'in_all_list' => __('All in list', 'zc-woo-pricely'),
                    'in_list_only' => __('Only in list', 'zc-woo-pricely'),
                    'in_all_list_only' => __('Only all in list', 'zc-woo-pricely'),
                    'none' => __('None in list', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => 'all_time',
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'all_time_category_ids',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'placeholder' => 'Product categories...',
                'data' => 'categories:product_cat',
                'width' => '100%',
                'box_width' => '40%',
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => 'all_time',
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
            ),
            array(
                'id' => 'category_ids',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'placeholder' => 'Product categories...',
                'data' => 'categories:product_cat',
                'width' => '100%',
                'box_width' => '28%',
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => 'all_time',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
            ),
        );

        $fields['purchased_categories'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-purchased_categories', 'zc_pri_validate_condition_purchased_categories', 10, 3);
if (!function_exists('zc_pri_validate_condition_purchased_categories')) {

    function zc_pri_validate_condition_purchased_categories($rule, $args) {


        $compare = $rule['all_time_compare'];
        if ($rule['date_type'] != 'all_time' && $rule['date_type'] != '') {
            $compare = $rule['compare'];
        }
        $rule_category_ids = $rule['all_time_category_ids'];
        if ($rule['date_type'] != 'all_time' && $rule['date_type'] != '') {
            $rule_category_ids = $rule['category_ids'];
        }
        if ($rule_category_ids == '') {
            return false;
        }

        $from_date = WooPricelyUtil::get_date_from_rule_value($rule);

        $category_ids = WooPricelyUtil::get_purchase_history(get_current_user_id(), 'category_ids', $from_date, true, true);
        
        if (count($category_ids) == 0) {
            return false;
        }

        return WooPricely_Validation_Util::validate_list_list($category_ids, $rule_category_ids, $compare);

    }

}